/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.util;

import com.mpush.api.Constants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public final class IOUtils {
    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] data) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream(data.length / 4);
        DeflaterOutputStream zipOut = new DeflaterOutputStream(byteStream);
        try {
            zipOut.write(data);
            zipOut.finish();
            zipOut.close();
        }
        catch (IOException e) {
            byte[] byArray = Constants.EMPTY_BYTES;
            return byArray;
        }
        finally {
            IOUtils.close(zipOut);
        }
        return byteStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] uncompress(byte[] data) {
        InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(data));
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length * 4);
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = in.read(buffer)) != -1) {
                out.write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            byte[] byArray = Constants.EMPTY_BYTES;
            return byArray;
        }
        finally {
            IOUtils.close(in);
        }
        return out.toByteArray();
    }
}

