/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.message.BaseMessage;
import com.mpush.message.ByteBufMessage;
import com.mpush.util.ByteBuf;
import java.nio.ByteBuffer;

public final class ErrorMessage
extends ByteBufMessage {
    public byte cmd;
    public byte code;
    public String reason;
    public String data;

    public ErrorMessage(byte cmd, Packet message, Connection connection) {
        super(message, connection);
        this.cmd = cmd;
    }

    public ErrorMessage(Packet message, Connection connection) {
        super(message, connection);
    }

    @Override
    public void decode(ByteBuffer body) {
        this.cmd = this.decodeByte(body);
        this.code = this.decodeByte(body);
        this.reason = this.decodeString(body);
        this.data = this.decodeString(body);
    }

    @Override
    public void encode(ByteBuf body) {
        this.encodeByte(body, this.cmd);
        this.encodeByte(body, this.code);
        this.encodeString(body, this.reason);
        this.encodeString(body, this.data);
    }

    public static ErrorMessage from(BaseMessage src) {
        return new ErrorMessage(src.packet.cmd, new Packet(Command.ERROR, src.packet.sessionId), src.connection);
    }

    public ErrorMessage setReason(String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    public void send() {
        super.sendRaw();
    }

    @Override
    public String toString() {
        return "ErrorMessage{cmd=" + this.cmd + ", code=" + this.code + ", reason='" + this.reason + '\'' + '}';
    }
}

