/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.client;

import com.mpush.api.Client;
import com.mpush.api.ClientListener;
import com.mpush.api.Logger;
import com.mpush.api.PacketReader;
import com.mpush.api.PacketReceiver;
import com.mpush.api.PacketWriter;
import com.mpush.api.connection.Connection;
import com.mpush.api.connection.SessionContext;
import com.mpush.api.protocol.Packet;
import com.mpush.client.AllotClient;
import com.mpush.client.ClientConfig;
import com.mpush.client.ConnectThread;
import com.mpush.client.MPushClient;
import com.mpush.codec.AsyncPacketReader;
import com.mpush.codec.AsyncPacketWriter;
import com.mpush.util.IOUtils;
import com.mpush.util.Strings;
import com.mpush.util.thread.EventLock;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public final class TcpConnection
implements Connection {
    private final AtomicReference<State> state = new AtomicReference<State>(State.disconnected);
    private final EventLock connLock = new EventLock();
    private final ClientConfig config;
    private final Logger logger;
    private final ClientListener listener;
    private final MPushClient client;
    private final PacketWriter writer;
    private final PacketReader reader;
    private final AllotClient allotClient;
    private SocketChannel channel;
    private SessionContext context;
    private long lastReadTime;
    private long lastWriteTime;
    private ConnectThread connectThread;
    private int totalReconnectCount;
    private volatile int reconnectCount = 0;
    private volatile boolean autoConnect = true;

    public TcpConnection(MPushClient client, PacketReceiver receiver) {
        this.client = client;
        this.config = ClientConfig.I;
        this.logger = this.config.getLogger();
        this.listener = this.config.getClientListener();
        this.allotClient = new AllotClient();
        this.reader = new AsyncPacketReader(this, receiver);
        this.writer = new AsyncPacketWriter(this, this.connLock);
    }

    private void onConnected(SocketChannel channel) {
        this.reconnectCount = 0;
        this.channel = channel;
        this.context = new SessionContext();
        this.state.set(State.connected);
        this.reader.startRead();
        this.logger.w("connection connected !!!", new Object[0]);
        this.listener.onConnected(this.client);
    }

    @Override
    public void close() {
        if (this.state.compareAndSet(State.connected, State.disconnecting)) {
            this.reader.stopRead();
            if (this.connectThread != null) {
                this.connectThread.shutdown();
            }
            this.doClose();
            this.logger.w("connection closed !!!", new Object[0]);
        }
    }

    private void doClose() {
        this.connLock.lock();
        try {
            SocketChannel channel = this.channel;
            if (channel != null) {
                if (channel.isOpen()) {
                    IOUtils.close(channel);
                    this.listener.onDisConnected(this.client);
                    this.logger.w("channel closed !!!", new Object[0]);
                }
                this.channel = null;
            }
        }
        finally {
            this.state.set(State.disconnected);
            this.connLock.unlock();
        }
    }

    @Override
    public void connect() {
        if (this.state.compareAndSet(State.disconnected, State.connecting)) {
            if (this.connectThread == null || !this.connectThread.isAlive()) {
                this.connectThread = new ConnectThread(this.connLock);
            }
            this.connectThread.addConnectTask(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return TcpConnection.this.doReconnect();
                }
            });
        }
    }

    @Override
    public void reconnect() {
        this.close();
        this.connect();
    }

    private boolean doReconnect() {
        if (this.totalReconnectCount > 1000 || !this.autoConnect) {
            this.logger.w("doReconnect failure reconnect count over limit or autoConnect off, total=%d, state=%s, autoConnect=%b", new Object[]{this.totalReconnectCount, this.state.get(), this.autoConnect});
            this.state.set(State.disconnected);
            return true;
        }
        ++this.reconnectCount;
        ++this.totalReconnectCount;
        this.logger.d("try doReconnect, count=%d, total=%d, autoConnect=%b, state=%s", new Object[]{this.reconnectCount, this.totalReconnectCount, this.autoConnect, this.state.get()});
        if (this.reconnectCount > 10) {
            if (this.connLock.await(TimeUnit.MINUTES.toMillis(10L))) {
                this.state.set(State.disconnected);
                return true;
            }
            this.reconnectCount = 0;
        } else if (this.reconnectCount > 2 && this.connLock.await(TimeUnit.SECONDS.toMillis(this.reconnectCount))) {
            this.state.set(State.disconnected);
            return true;
        }
        if (Thread.currentThread().isInterrupted() || this.state.get() != State.connecting || !this.autoConnect) {
            this.logger.w("doReconnect failure, count=%d, total=%d, autoConnect=%b, state=%s", new Object[]{this.reconnectCount, this.totalReconnectCount, this.autoConnect, this.state.get()});
            this.state.set(State.disconnected);
            return true;
        }
        this.logger.w("doReconnect, count=%d, total=%d, autoConnect=%b, state=%s", new Object[]{this.reconnectCount, this.totalReconnectCount, this.autoConnect, this.state.get()});
        return this.doConnect();
    }

    private boolean doConnect() {
        List<String> address = this.allotClient.getServerAddress();
        if (address != null && address.size() > 0) {
            for (int i = 0; i < address.size(); ++i) {
                int port;
                String host;
                String[] host_port = address.get(i).split(":");
                if (host_port.length == 2 && this.doConnect(host = host_port[0], port = Strings.toInt(host_port[1], 0))) {
                    return true;
                }
                address.remove(i--);
            }
        }
        return false;
    }

    private boolean doConnect(String host, int port) {
        this.connLock.lock();
        this.logger.w("try connect server [%s:%s]", host, port);
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            channel.socket().setTcpNoDelay(true);
            channel.socket().setKeepAlive(true);
            channel.connect(new InetSocketAddress(host, port));
            this.logger.w("connect server ok [%s:%s]", host, port);
            this.onConnected(channel);
            this.connLock.signalAll();
            this.connLock.unlock();
            return true;
        }
        catch (Throwable t) {
            IOUtils.close(channel);
            this.connLock.unlock();
            this.logger.e(t, "connect server ex, [%s:%s]", host, port);
            return false;
        }
    }

    public void setAutoConnect(boolean autoConnect) {
        this.connLock.lock();
        this.autoConnect = autoConnect;
        this.connLock.signalAll();
        this.connLock.unlock();
    }

    @Override
    public void send(Packet packet) {
        this.writer.write(packet);
    }

    @Override
    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public boolean isConnected() {
        return this.state.get() == State.connected;
    }

    @Override
    public void setLastReadTime() {
        this.lastReadTime = System.currentTimeMillis();
    }

    @Override
    public void setLastWriteTime() {
        this.lastWriteTime = System.currentTimeMillis();
    }

    @Override
    public boolean isReadTimeout() {
        return System.currentTimeMillis() - this.lastReadTime > (long)(this.context.heartbeat + 1000);
    }

    @Override
    public SessionContext getSessionContext() {
        return this.context;
    }

    @Override
    public boolean isWriteTimeout() {
        return System.currentTimeMillis() - this.lastWriteTime > (long)(this.context.heartbeat - 1000);
    }

    public String toString() {
        return "TcpConnection{, lastReadTime=" + this.lastReadTime + ", lastWriteTime=" + this.lastWriteTime + ", context=" + this.context + '}';
    }

    public static enum State {
        connecting,
        connected,
        disconnecting,
        disconnected;

    }
}

