/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SystemOfUnits;
import com.github.pires.obd.enums.AvailableCommandNames;

public class SpeedObdCommand
extends ObdCommand
implements SystemOfUnits {
    private int metricSpeed = 0;

    public SpeedObdCommand() {
        super("01 0D");
    }

    public SpeedObdCommand(SpeedObdCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        this.metricSpeed = (Integer)this.buffer.get(2);
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.0f%s", Float.valueOf(this.getImperialUnit()), "mph") : String.format("%d%s", this.getMetricSpeed(), "km/h");
    }

    public int getMetricSpeed() {
        return this.metricSpeed;
    }

    public float getImperialSpeed() {
        return this.getImperialUnit();
    }

    @Override
    public float getImperialUnit() {
        return new Double((double)this.metricSpeed * 0.621371192).floatValue();
    }

    @Override
    public String getName() {
        return AvailableCommandNames.SPEED.getValue();
    }
}

