/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;

public class DtcNumberObdCommand
extends ObdCommand {
    private int codeCount = 0;
    private boolean milOn = false;

    public DtcNumberObdCommand() {
        super("01 01");
    }

    public DtcNumberObdCommand(DtcNumberObdCommand other) {
        super(other);
    }

    @Override
    protected void performCalculations() {
        int mil = (Integer)this.buffer.get(2);
        this.milOn = (mil & 0x80) == 128;
        this.codeCount = mil & 0x7F;
    }

    @Override
    public String getFormattedResult() {
        String res = this.milOn ? "MIL is ON" : "MIL is OFF";
        return res + this.codeCount + " codes";
    }

    public int getTotalAvailableCodes() {
        return this.codeCount;
    }

    public boolean getMilOn() {
        return this.milOn;
    }

    @Override
    public String getName() {
        return AvailableCommandNames.DTC_NUMBER.getValue();
    }
}

