/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.control;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.AvailableCommandNames;
import java.io.IOException;
import java.io.InputStream;

public class TroubleCodesObdCommand
extends ObdCommand {
    protected static final char[] dtcLetters = new char[]{'P', 'C', 'B', 'U'};
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private StringBuffer codes = new StringBuffer();

    public TroubleCodesObdCommand() {
        super("03");
    }

    public TroubleCodesObdCommand(TroubleCodesObdCommand other) {
        super(other);
    }

    @Override
    protected void fillBuffer() {
    }

    @Override
    protected void performCalculations() {
        String workingData = this.getResult().replaceAll("[\r\n]", "");
        int begin = 0;
        int i = 0;
        while (begin < workingData.length()) {
            begin += 2;
            for (int j = 0; j < 3; ++j) {
                String dtc = "";
                byte b1 = this.hexStringToByteArray(workingData.charAt(begin));
                int ch1 = (b1 & 0xC0) >> 6;
                int ch2 = (b1 & 0x30) >> 4;
                dtc = dtc + dtcLetters[ch1];
                dtc = dtc + hexArray[ch2];
                if ((dtc = dtc + workingData.substring(++begin, begin + 3)).equals("P0000")) {
                    return;
                }
                this.codes.append(dtc);
                this.codes.append('\n');
                begin += 3;
            }
            ++i;
        }
    }

    private byte hexStringToByteArray(char s) {
        return (byte)(Character.digit(s, 16) << 4);
    }

    public String formatResult() {
        return this.codes.toString();
    }

    @Override
    protected void readRawData(InputStream in) throws IOException {
        byte b = 0;
        StringBuilder res = new StringBuilder();
        while ((char)(b = (byte)in.read()) != '>') {
            if ((char)b == ' ') continue;
            res.append((char)b);
        }
        this.rawData = res.toString().trim();
    }

    @Override
    public String getFormattedResult() {
        return this.codes.toString();
    }

    @Override
    public String getName() {
        return AvailableCommandNames.TROUBLE_CODES.getValue();
    }
}

