/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.fuel;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.enums.FuelTrim;

public class FuelTrimObdCommand
extends ObdCommand {
    private float fuelTrimValue = 0.0f;
    private final FuelTrim bank;

    public FuelTrimObdCommand(FuelTrim bank) {
        super(bank.buildObdCommand());
        this.bank = bank;
    }

    private float prepareTempValue(int value) {
        return new Double((double)(value - 128) * 0.78125).floatValue();
    }

    @Override
    protected void performCalculations() {
        this.fuelTrimValue = this.prepareTempValue((Integer)this.buffer.get(2));
    }

    @Override
    public String getFormattedResult() {
        return String.format("%.2f%s", Float.valueOf(this.fuelTrimValue), "%");
    }

    public final float getValue() {
        return this.fuelTrimValue;
    }

    public final String getBank() {
        return this.bank.getBank();
    }

    @Override
    public String getName() {
        return this.bank.getBank();
    }
}

