/*
 * Decompiled with CFR 0.152.
 */
package com.github.pires.obd.commands.pressure;

import com.github.pires.obd.commands.ObdCommand;
import com.github.pires.obd.commands.SystemOfUnits;

public abstract class PressureObdCommand
extends ObdCommand
implements SystemOfUnits {
    protected int tempValue = 0;
    protected int pressure = 0;

    public PressureObdCommand(String cmd) {
        super(cmd);
    }

    public PressureObdCommand(PressureObdCommand other) {
        super(other);
    }

    protected int preparePressureValue() {
        return (Integer)this.buffer.get(2);
    }

    @Override
    protected void performCalculations() {
        this.pressure = this.preparePressureValue();
    }

    @Override
    public String getFormattedResult() {
        return this.useImperialUnits ? String.format("%.1f%s", Float.valueOf(this.getImperialUnit()), "psi") : String.format("%d%s", this.pressure, "kPa");
    }

    public int getMetricUnit() {
        return this.pressure;
    }

    @Override
    public float getImperialUnit() {
        return new Double((double)this.pressure * 0.145037738).floatValue();
    }
}

