/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.script;

import com.jarvis.cache.annotation.Cache;
import com.jarvis.cache.annotation.CacheDeleteKey;
import com.jarvis.cache.annotation.CacheDeleteMagicKey;
import com.jarvis.cache.annotation.ExCache;
import com.jarvis.cache.type.CacheOpType;
import java.lang.reflect.Method;

public abstract class AbstractScriptParser {
    protected static final String TARGET = "target";
    protected static final String ARGS = "args";
    protected static final String RET_VAL = "retVal";
    protected static final String HASH = "hash";
    protected static final String EMPTY = "empty";

    public abstract void addFunction(String var1, Method var2);

    public abstract <T> T getElValue(String var1, Object var2, Object[] var3, Object var4, boolean var5, Class<T> var6) throws Exception;

    public <T> T getElValue(String keyEL, Object target, Object[] arguments, Class<T> valueType) throws Exception {
        return this.getElValue(keyEL, target, arguments, null, false, valueType);
    }

    public String getDefinedCacheKey(String keyEL, Object target, Object[] arguments, Object retVal, boolean hasRetVal) throws Exception {
        return this.getElValue(keyEL, target, arguments, retVal, hasRetVal, String.class);
    }

    public boolean isCacheable(Cache cache, Object target, Object[] arguments) throws Exception {
        boolean rv = true;
        if (null != arguments && arguments.length > 0 && null != cache.condition() && cache.condition().length() > 0) {
            rv = this.getElValue(cache.condition(), target, arguments, Boolean.class);
        }
        return rv;
    }

    public boolean isCacheable(Cache cache, Object target, Object[] arguments, Object result) throws Exception {
        boolean rv = true;
        if (null != cache.condition() && cache.condition().length() > 0) {
            rv = this.getElValue(cache.condition(), target, arguments, result, true, Boolean.class);
        }
        return rv;
    }

    public boolean isCacheable(ExCache cache, Object target, Object[] arguments, Object result) throws Exception {
        if (null == cache || cache.expire() < 0 || cache.key().length() == 0) {
            return false;
        }
        boolean rv = true;
        if (null != cache.condition() && cache.condition().length() > 0) {
            rv = this.getElValue(cache.condition(), target, arguments, result, true, Boolean.class);
        }
        return rv;
    }

    public boolean isAutoload(Cache cache, Object target, Object[] arguments, Object retVal) throws Exception {
        if (cache.opType() == CacheOpType.WRITE) {
            return false;
        }
        boolean autoload = cache.autoload();
        if (null != arguments && arguments.length > 0 && null != cache.autoloadCondition() && cache.autoloadCondition().length() > 0) {
            autoload = this.getElValue(cache.autoloadCondition(), target, arguments, retVal, true, Boolean.class);
        }
        return autoload;
    }

    public boolean isCanDelete(CacheDeleteKey cacheDeleteKey, Object[] arguments, Object retVal) throws Exception {
        boolean rv = true;
        String condition = cacheDeleteKey.condition();
        if (null != condition && condition.length() > 0) {
            rv = this.getElValue(condition, null, arguments, retVal, true, Boolean.class);
        }
        return rv;
    }

    public boolean isCanDelete(CacheDeleteMagicKey cacheDeleteKey, Object[] arguments, Object retVal) throws Exception {
        boolean rv = true;
        String condition = cacheDeleteKey.condition();
        if (null != condition && condition.length() > 0) {
            rv = this.getElValue(condition, null, arguments, retVal, true, Boolean.class);
        }
        return rv;
    }

    public int getRealExpire(int expire, String expireExpression, Object[] arguments, Object result) throws Exception {
        Integer tmpExpire = null;
        if (null != expireExpression && expireExpression.length() > 0 && null != (tmpExpire = this.getElValue(expireExpression, null, arguments, result, true, Integer.class)) && tmpExpire >= 0) {
            return tmpExpire;
        }
        return expire;
    }
}

