package com.github.rameshl.appengine.test.base;

import com.github.rameshl.appengine.test.definition.CodeBlock;

import static org.junit.Assert.fail;

/**
 * gae-test-util Created by Ramesh on 7/6/18.
 */
public class TestBase {

    public void expectIllegalArgException(CodeBlock block, String exceptionMsg, String failMsg) throws Exception {
        expectException(block, IllegalArgumentException.class, exceptionMsg, failMsg);
    }

    public void expectException(CodeBlock block, Class<? extends Exception> clazz, String exceptionMsg) throws Exception {
        expectException(block, clazz, exceptionMsg, null);
    }

    public void expectException(CodeBlock block, Class<? extends Exception> clazz, String exceptionMsg, String failMsg) throws Exception {

        try {
            block.run();

            if (failMsg == null)
                failMsg = clazz.getName() + " exception expected";

            fail(failMsg);

        } catch (Exception ex) {
            if (!clazz.equals(ex.getClass()))
                throw ex;

            if (exceptionMsg != null && !exceptionMsg.equals(ex.getMessage()))
                fail("exception message doesn't match, expected message: " + exceptionMsg + ", actual : " + ex.getMessage());
        }
    }
}
