package com.github.rameshl.appengine.test.gae;

import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.common.collect.ImmutableMap;

import com.github.rameshl.appengine.test.base.TestBase;
import com.github.rameshl.appengine.test.enums.GaeServiceHelperType;
import com.github.rameshl.appengine.test.model.UserInfo;

import org.junit.After;
import org.junit.Before;

/**
 * gae-test-util Created by Ramesh on 7/6/18.
 */
public abstract class GaeGenericTestBase extends TestBase {

    /**
     * The helper.
     */
    protected final LocalServiceTestHelper helper;

    /**
     * Instantiates a new Gae generic test base.
     */
    public GaeGenericTestBase() {
        this(GaeServiceHelperType.values());
    }

    /**
     * Instantiates a new abstract gae generic test base.
     *
     * @param types the service types
     */
    public GaeGenericTestBase(GaeServiceHelperType... types) {
        this(GaeServiceHelperType.getConfigs(types));
    }

    /**
     * Instantiates a new abstract gae generic test base.
     *
     * @param configs the configs
     */
    public GaeGenericTestBase(LocalServiceTestConfig... configs) {

        helper = new LocalServiceTestHelper(configs);

//        SystemProperty.version.set("JUnitVersion");
//        SystemProperty.applicationId.set("JUnitApplicationId");
//        SystemProperty.applicationVersion.set("JUnitApplicationVersion");
        SystemProperty.environment.set(SystemProperty.Environment.Value.Development);
    }

    public void setUserInfo(UserInfo userInfo) {
        helper.setEnvIsLoggedIn(userInfo.isLoggedIn())
                .setEnvIsAdmin(userInfo.isAdmin())
                .setEnvAuthDomain(userInfo.getAuthDomain())
                .setEnvEmail(userInfo.getEmail())
                // This envAttributes thing is the only way to set userId.
                // see https://code.google.com/p/googleappengine/issues/detail?id=3579
                .setEnvAttributes(ImmutableMap.<String, Object>of("com.google.appengine.api.users.UserService.user_id_key", userInfo.getUserId()));
    }

    /**
     * Sets the up.
     */
    @Before
    public void gaeSetUp() {
        this.helper.setUp();
    }

    /**
     * Tear down.
     */
    @After
    public void gaeTearDown() {
        this.helper.tearDown();
    }
}
