/*
 * Decompiled with CFR 0.152.
 */
package com.github.rameshl.appengine.test;

import com.google.appengine.tools.development.testing.LocalDatastoreServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalMemcacheServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalTaskQueueTestConfig;
import com.google.appengine.tools.development.testing.LocalURLFetchServiceTestConfig;

public enum GaeTestConfigType {
    Datastore,
    Queue,
    Memcache,
    UrlFetch;


    public static LocalDatastoreServiceTestConfig datastoreConfig() {
        return new LocalDatastoreServiceTestConfig().setApplyAllHighRepJobPolicy().setNoIndexAutoGen(false);
    }

    public static LocalMemcacheServiceTestConfig memcacheConfig() {
        return new LocalMemcacheServiceTestConfig();
    }

    public static LocalTaskQueueTestConfig queueConfig() {
        return new LocalTaskQueueTestConfig();
    }

    public static LocalURLFetchServiceTestConfig urlFetchConfig() {
        return new LocalURLFetchServiceTestConfig();
    }

    public static LocalServiceTestConfig[] allConfig() {
        return new LocalServiceTestConfig[]{GaeTestConfigType.datastoreConfig(), GaeTestConfigType.memcacheConfig(), GaeTestConfigType.queueConfig()};
    }

    public LocalServiceTestConfig getConfig() {
        switch (this) {
            case Datastore: {
                return GaeTestConfigType.datastoreConfig();
            }
            case Memcache: {
                return GaeTestConfigType.memcacheConfig();
            }
            case Queue: {
                return GaeTestConfigType.queueConfig();
            }
            case UrlFetch: {
                return GaeTestConfigType.urlFetchConfig();
            }
        }
        return null;
    }
}

