/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.Codec;
import com.buck.common.codec.CodecDecoder;
import com.buck.common.codec.CodecEncoder;
import com.buck.common.codec.StandardCodecs;

public class Base32
extends Codec {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 32;
    private static final int FORTYBITGROUP = 40;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int TWENTYFOURBIT = 24;
    private static final int THIRTYTWOBIT = 32;
    private static final int EIGHTBYTE = 8;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final byte[] base32Alphabet;
    private static final byte[] lookUpBase32Alphabet;
    private static final byte[] EMPTY_STRING;

    private static boolean isWhiteSpace(byte octet) {
        return octet == 32 || octet == 13 || octet == 10 || octet == 9;
    }

    private static boolean isPad(byte octet) {
        return octet == 61;
    }

    private static boolean isData(byte octet) {
        return (0xFF & octet) <= 128 && base32Alphabet[0xFF & octet] != -1;
    }

    private static int removeWhiteSpace(byte[] data) {
        if (data == null) {
            return 0;
        }
        int newSize = 0;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            if (Base32.isWhiteSpace(data[i])) continue;
            data[newSize++] = data[i];
        }
        return newSize;
    }

    public Base32() {
        super("base32", StandardCodecs.aliases_Base32);
    }

    @Override
    public CodecDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CodecEncoder newEncoder() {
        return new Encoder(this);
    }

    static {
        int i;
        base32Alphabet = new byte[128];
        lookUpBase32Alphabet = new byte[32];
        for (i = 0; i < 128; ++i) {
            Base32.base32Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base32.base32Alphabet[i] = (byte)(i - 65);
        }
        for (i = 55; i >= 50; --i) {
            Base32.base32Alphabet[i] = (byte)(i - 50 + 26);
        }
        for (i = 0; i <= 25; ++i) {
            Base32.lookUpBase32Alphabet[i] = (byte)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 31) {
            Base32.lookUpBase32Alphabet[i] = (byte)(50 + j);
            ++i;
            ++j;
        }
        EMPTY_STRING = new byte[0];
    }

    private static class Encoder
    extends CodecEncoder {
        public Encoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] encode(byte[] bytes) {
            byte r3;
            byte val4;
            byte r2;
            byte val3;
            byte val2;
            byte r1;
            byte val1;
            byte b4;
            byte b3;
            byte b2;
            byte b1;
            if (bytes == null) {
                return null;
            }
            int lengthDataBits = bytes.length * 8;
            if (lengthDataBits == 0) {
                return EMPTY_STRING;
            }
            int fewerThan40bits = lengthDataBits % 40;
            int numberQuintets = lengthDataBits / 40;
            int numberOctets = fewerThan40bits != 0 ? numberQuintets + 1 : numberQuintets;
            byte[] encoded = new byte[numberOctets * 8];
            int encodedIndex = 0;
            int dataIndex = 0;
            for (int i = 0; i < numberQuintets; ++i) {
                b1 = bytes[dataIndex++];
                b2 = bytes[dataIndex++];
                b3 = bytes[dataIndex++];
                b4 = bytes[dataIndex++];
                byte b5 = bytes[dataIndex++];
                byte val12 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 3) : (byte)(b1 >> 3 ^ 0xE0);
                byte r12 = (byte)(b1 & 7);
                byte val22 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 6) : (byte)(b2 >> 6 ^ 0xFC);
                byte val32 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 1) : (byte)(b2 >> 1 ^ 0xE0);
                byte r22 = (byte)(b2 & 1);
                byte val42 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 4) : (byte)(b3 >> 4 ^ 0xF0);
                byte r32 = (byte)(b3 & 0xF);
                byte val5 = (b4 & 0xFFFFFF80) == 0 ? (byte)(b4 >> 7) : (byte)(b4 >> 7 ^ 0xFE);
                byte val6 = (b4 & 0xFFFFFF80) == 0 ? (byte)(b4 >> 2) : (byte)(b4 >> 2 ^ 0xE0);
                byte r4 = (byte)(b4 & 3);
                byte val7 = (b5 & 0xFFFFFF80) == 0 ? (byte)(b5 >> 5) : (byte)(b5 >> 5 ^ 0xF8);
                byte r5 = (byte)(b5 & 0x1F);
                encoded[encodedIndex++] = lookUpBase32Alphabet[val12 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r12 << 2 | val22];
                encoded[encodedIndex++] = lookUpBase32Alphabet[val32 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r22 << 4 | val42];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r32 << 1 | val5];
                encoded[encodedIndex++] = lookUpBase32Alphabet[val6 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r4 << 3 | val7];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r5 & 0x1F];
            }
            if (fewerThan40bits == 8) {
                b1 = bytes[dataIndex];
                val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 3) : (byte)(b1 >> 3 ^ 0xE0);
                r1 = (byte)(b1 & 7);
                encoded[encodedIndex++] = lookUpBase32Alphabet[val1 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r1 << 2];
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex] = 61;
            } else if (fewerThan40bits == 16) {
                b1 = bytes[dataIndex++];
                b2 = bytes[dataIndex];
                val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 3) : (byte)(b1 >> 3 ^ 0xE0);
                r1 = (byte)(b1 & 7);
                val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 6) : (byte)(b2 >> 6 ^ 0xFC);
                val3 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 1) : (byte)(b2 >> 1 ^ 0xE0);
                r2 = (byte)(b2 & 1);
                encoded[encodedIndex++] = lookUpBase32Alphabet[val1 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r1 << 2 | val2];
                encoded[encodedIndex++] = lookUpBase32Alphabet[val3 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r2 << 4];
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex] = 61;
            } else if (fewerThan40bits == 24) {
                b1 = bytes[dataIndex++];
                b2 = bytes[dataIndex++];
                b3 = bytes[dataIndex];
                val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 3) : (byte)(b1 >> 3 ^ 0xE0);
                r1 = (byte)(b1 & 7);
                val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 6) : (byte)(b2 >> 6 ^ 0xFC);
                val3 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 1) : (byte)(b2 >> 1 ^ 0xE0);
                r2 = (byte)(b2 & 1);
                val4 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 4) : (byte)(b3 >> 4 ^ 0xF0);
                r3 = (byte)(b3 & 0xF);
                encoded[encodedIndex++] = lookUpBase32Alphabet[val1 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r1 << 2 | val2];
                encoded[encodedIndex++] = lookUpBase32Alphabet[val3 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r2 << 4 | val4];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r3 << 1];
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex] = 61;
            } else if (fewerThan40bits == 32) {
                b1 = bytes[dataIndex++];
                b2 = bytes[dataIndex++];
                b3 = bytes[dataIndex++];
                b4 = bytes[dataIndex];
                val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 3) : (byte)(b1 >> 3 ^ 0xE0);
                r1 = (byte)(b1 & 7);
                val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 6) : (byte)(b2 >> 6 ^ 0xFC);
                val3 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 1) : (byte)(b2 >> 1 ^ 0xE0);
                r2 = (byte)(b2 & 1);
                val4 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 4) : (byte)(b3 >> 4 ^ 0xF0);
                r3 = (byte)(b3 & 0xF);
                byte val5 = (b4 & 0xFFFFFF80) == 0 ? (byte)(b4 >> 7) : (byte)(b4 >> 7 ^ 0xFE);
                byte val6 = (b4 & 0xFFFFFF80) == 0 ? (byte)(b4 >> 2) : (byte)(b4 >> 2 ^ 0xE0);
                byte r4 = (byte)(b4 & 3);
                encoded[encodedIndex++] = lookUpBase32Alphabet[val1 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r1 << 2 | val2];
                encoded[encodedIndex++] = lookUpBase32Alphabet[val3 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r2 << 4 | val4];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r3 << 1 | val5];
                encoded[encodedIndex++] = lookUpBase32Alphabet[val6 & 0x1F];
                encoded[encodedIndex++] = lookUpBase32Alphabet[r4 << 3];
                encoded[encodedIndex] = 61;
            }
            return encoded;
        }
    }

    private static class Decoder
    extends CodecDecoder {
        public Decoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] decode(byte[] encoded) {
            byte b8;
            byte b7;
            byte b6;
            byte b5;
            byte b4;
            byte b3;
            byte b2;
            byte b1;
            byte d8;
            byte d7;
            byte d6;
            byte d5;
            byte d4;
            byte d3;
            byte d2;
            byte d1;
            int i;
            if (encoded == null) {
                return null;
            }
            int len = Base32.removeWhiteSpace(encoded);
            if (len % 8 != 0) {
                return null;
            }
            int numberOfEights = len / 8;
            if (numberOfEights == 0) {
                return EMPTY_STRING;
            }
            int encodedIndex = 0;
            int dataIndex = 0;
            byte[] decodedData = new byte[numberOfEights * 5];
            for (i = 0; i < numberOfEights - 1; ++i) {
                if (!(Base32.isData(d1 = encoded[dataIndex++]) && Base32.isData(d2 = encoded[dataIndex++]) && Base32.isData(d3 = encoded[dataIndex++]) && Base32.isData(d4 = encoded[dataIndex++]) && Base32.isData(d5 = encoded[dataIndex++]) && Base32.isData(d6 = encoded[dataIndex++]) && Base32.isData(d7 = encoded[dataIndex++]) && Base32.isData(d8 = encoded[dataIndex++]))) {
                    return null;
                }
                b1 = base32Alphabet[d1];
                b2 = base32Alphabet[d2];
                b3 = base32Alphabet[d3];
                b4 = base32Alphabet[d4];
                b5 = base32Alphabet[d5];
                b6 = base32Alphabet[d6];
                b7 = base32Alphabet[d7];
                b8 = base32Alphabet[d8];
                decodedData[encodedIndex++] = (byte)(b1 << 3 | b2 >> 2);
                decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 6 | b3 << 1 | b4 >> 4 & 0xF);
                decodedData[encodedIndex++] = (byte)((b4 & 0xF) << 4 | b5 >> 1 & 0xF);
                decodedData[encodedIndex++] = (byte)((b5 & 0xF) << 7 | b6 << 2 | b7 >> 3 & 0xF);
                decodedData[encodedIndex++] = (byte)(b7 << 5 | b8);
            }
            if (!Base32.isData(d1 = encoded[dataIndex++]) || !Base32.isData(d2 = encoded[dataIndex++])) {
                return null;
            }
            b1 = base32Alphabet[d1];
            b2 = base32Alphabet[d2];
            d3 = encoded[dataIndex++];
            d4 = encoded[dataIndex++];
            d5 = encoded[dataIndex++];
            d6 = encoded[dataIndex++];
            d7 = encoded[dataIndex++];
            d8 = encoded[dataIndex];
            if (!(Base32.isData(d3) && Base32.isData(d4) && Base32.isData(d5) && Base32.isData(d6) && Base32.isData(d7) && Base32.isData(d8))) {
                if (Base32.isPad(d3) && Base32.isPad(d4) && Base32.isPad(d5) && Base32.isPad(d6) && Base32.isPad(d7) && Base32.isPad(d8)) {
                    if ((b2 & 3) != 0) {
                        return null;
                    }
                    byte[] tmp = new byte[i * 5 + 1];
                    System.arraycopy(decodedData, 0, tmp, 0, i * 5);
                    tmp[encodedIndex] = (byte)(b1 << 3 | b2 >> 2);
                    return tmp;
                }
                if (!Base32.isPad(d3) && !Base32.isPad(d4) && Base32.isPad(d5) && Base32.isPad(d6) && Base32.isPad(d7) && Base32.isPad(d8)) {
                    b3 = base32Alphabet[d3];
                    b4 = base32Alphabet[d4];
                    if ((b4 & 0xF) != 0) {
                        return null;
                    }
                    byte[] tmp = new byte[i * 5 + 2];
                    System.arraycopy(decodedData, 0, tmp, 0, i * 5);
                    tmp[encodedIndex++] = (byte)(b1 << 3 | b2 >> 2);
                    tmp[encodedIndex] = (byte)((b2 & 0xF) << 6 | b3 << 1 | b4 >> 4 & 0xF);
                    return tmp;
                }
                if (!Base32.isPad(d3) && !Base32.isPad(d4) && !Base32.isPad(d5) && Base32.isPad(d6) && Base32.isPad(d7) && Base32.isPad(d8)) {
                    b3 = base32Alphabet[d3];
                    b4 = base32Alphabet[d4];
                    b5 = base32Alphabet[d5];
                    if ((b5 & 1) != 0) {
                        return null;
                    }
                    byte[] tmp = new byte[i * 5 + 3];
                    System.arraycopy(decodedData, 0, tmp, 0, i * 5);
                    tmp[encodedIndex++] = (byte)(b1 << 3 | b2 >> 2);
                    tmp[encodedIndex++] = (byte)((b2 & 0xF) << 6 | b3 << 1 | b4 >> 4 & 0xF);
                    tmp[encodedIndex] = (byte)((b4 & 0xF) << 4 | b5 >> 1 & 0xF);
                    return tmp;
                }
                if (!(Base32.isPad(d3) || Base32.isPad(d4) || Base32.isPad(d5) || Base32.isPad(d6) || Base32.isPad(d7) || !Base32.isPad(d8))) {
                    b3 = base32Alphabet[d3];
                    b4 = base32Alphabet[d4];
                    b5 = base32Alphabet[d5];
                    b6 = base32Alphabet[d6];
                    b7 = base32Alphabet[d7];
                    if ((b7 & 7) != 0) {
                        return null;
                    }
                    byte[] tmp = new byte[i * 5 + 4];
                    System.arraycopy(decodedData, 0, tmp, 0, i * 5);
                    tmp[encodedIndex++] = (byte)(b1 << 3 | b2 >> 2);
                    tmp[encodedIndex++] = (byte)((b2 & 0xF) << 6 | b3 << 1 | b4 >> 4 & 0xF);
                    tmp[encodedIndex++] = (byte)((b4 & 0xF) << 4 | b5 >> 1 & 0xF);
                    tmp[encodedIndex] = (byte)((b5 & 0xF) << 7 | b6 << 2 | b7 >> 3 & 0xF);
                    return tmp;
                }
                return null;
            }
            b3 = base32Alphabet[d3];
            b4 = base32Alphabet[d4];
            b5 = base32Alphabet[d5];
            b6 = base32Alphabet[d6];
            b7 = base32Alphabet[d7];
            b8 = base32Alphabet[d8];
            decodedData[encodedIndex++] = (byte)(b1 << 3 | b2 >> 2);
            decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 6 | b3 << 1 | b4 >> 4 & 0xF);
            decodedData[encodedIndex++] = (byte)((b4 & 0xF) << 4 | b5 >> 1 & 0xF);
            decodedData[encodedIndex++] = (byte)((b5 & 0xF) << 7 | b6 << 2 | b7 >> 3 & 0xF);
            decodedData[encodedIndex] = (byte)(b7 << 5 | b8);
            return decodedData;
        }
    }
}

