/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.Codec;
import com.buck.common.codec.CodecDecoder;
import com.buck.common.codec.CodecEncoder;
import com.buck.common.codec.MalformedInputException;
import com.buck.common.codec.PercentEncoded;
import com.buck.common.codec.StandardCodecs;
import com.buck.commons.i18n.ResourceBundle;
import java.io.ByteArrayOutputStream;
import java.util.BitSet;

public class URLEncoded
extends Codec {
    private static final byte ESCAPE_CHAR = 37;
    private static final BitSet WWW_FORM_URL;

    public URLEncoded() {
        super("x-www-form-urlencoded", StandardCodecs.aliases_URLEncoded);
    }

    @Override
    public CodecDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CodecEncoder newEncoder() {
        return new Encoder(this);
    }

    static {
        int i;
        WWW_FORM_URL = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            WWW_FORM_URL.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            WWW_FORM_URL.set(i);
        }
        WWW_FORM_URL.set(45);
        WWW_FORM_URL.set(95);
        WWW_FORM_URL.set(46);
        WWW_FORM_URL.set(42);
        WWW_FORM_URL.set(32);
    }

    private static class Encoder
    extends CodecEncoder {
        public Encoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] encode(byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (int n : bytes) {
                int b = n;
                if (b < 0) {
                    b = 256 + b;
                }
                if (WWW_FORM_URL.get(b)) {
                    if (b == 32) {
                        b = 43;
                    }
                    buffer.write(b);
                    continue;
                }
                buffer.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                buffer.write(hex1);
                buffer.write(hex2);
            }
            return buffer.toByteArray();
        }
    }

    private static class Decoder
    extends CodecDecoder {
        public Decoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] decode(byte[] encoded) {
            if (encoded == null) {
                return null;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (int i = 0; i < encoded.length; ++i) {
                byte b = encoded[i];
                if (b == 43) {
                    buffer.write(32);
                    continue;
                }
                if (b == 37) {
                    try {
                        int u = Character.digit((char)encoded[++i], 16);
                        int l = Character.digit((char)encoded[++i], 16);
                        if (u == -1 || l == -1) {
                            Object[] arguments = new Object[]{"www-form-urlencoded"};
                            String message = ResourceBundle.formatResourceBundleMessage(PercentEncoded.class, (String)"CODEC_DECODER_MALFORMED_INPUT", (Object[])arguments);
                            throw new MalformedInputException(message);
                        }
                        buffer.write((char)((u << 4) + l));
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        Object[] arguments = new Object[]{(byte)37};
                        String message = ResourceBundle.formatResourceBundleMessage(PercentEncoded.class, (String)"CODEC_DECODER_INCOMPLETE_ESCAPE", (Object[])arguments);
                        throw new MalformedInputException(message, e);
                    }
                }
                buffer.write(b);
            }
            return buffer.toByteArray();
        }
    }
}

