/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesprint.rx;

import io.reactivesprint.Preconditions;
import io.reactivesprint.rx.IMutableProperty;
import io.reactivesprint.rx.IProperty;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.internal.util.SubscriptionList;
import rx.subjects.BehaviorSubject;
import rx.subjects.Subject;

public final class MutableProperty<V>
implements IMutableProperty<V> {
    private V value;
    private final Object lock = new Object();
    private final Subject<V, V> valueSubject;
    private final Observable<V> valueObservable;

    public MutableProperty(V initialValue) {
        this.value = initialValue;
        this.valueSubject = BehaviorSubject.create(initialValue);
        this.valueObservable = this.valueSubject.asObservable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.value;
        }
    }

    @Override
    public Observable<V> getObservable() {
        return this.valueObservable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(V value) {
        Object object = this.lock;
        synchronized (object) {
            this.value = value;
        }
        this.valueSubject.onNext(value);
    }

    public static <Value> Subscription bind(final IMutableProperty<Value> destination, Observable<Value> source) {
        Preconditions.checkNotNull(destination, "destination");
        Preconditions.checkNotNull(source, "source");
        final SubscriptionList subscriptionList = new SubscriptionList();
        destination.getObservable().subscribe(new Observer<Value>(){

            public void onCompleted() {
                subscriptionList.unsubscribe();
            }

            public void onError(Throwable e) {
            }

            public void onNext(Value value) {
            }
        });
        subscriptionList.add(source.subscribe(new Subscriber<Value>(){

            public void onCompleted() {
                subscriptionList.unsubscribe();
            }

            public void onError(Throwable e) {
            }

            public void onNext(Value value) {
                destination.setValue(value);
            }
        }));
        return subscriptionList;
    }

    public static <V> Subscription bind(IMutableProperty<V> destination, IProperty<V> source) {
        Preconditions.checkNotNull(destination, "destination");
        Preconditions.checkNotNull(source, "source");
        return destination.bind(source.getObservable());
    }

    @Override
    public Subscription bind(Observable<V> source) {
        Preconditions.checkNotNull(source, "source");
        return MutableProperty.bind(this, source);
    }

    @Override
    public Subscription bind(IProperty<V> source) {
        Preconditions.checkNotNull(source, "source");
        return MutableProperty.bind(this, source);
    }

    protected void finalize() throws Throwable {
        this.valueSubject.onCompleted();
        super.finalize();
    }
}

