/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver;

import com.rodbate.httpserver.HttpServerInitializerFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bootstrap.class);
    private static final int PORT = 8888;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new HttpServerInitializerFactory());
            Channel channel = bootstrap.bind(8888).sync().channel();
            Bootstrap.printLogo();
            LOGGER.info("========>>>>>>>> Open your web browser and navigate to http://127.0.0.1:8888");
            channel.closeFuture().sync();
        }
        catch (Exception exception) {
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLogo() {
        StringBuilder logo = new StringBuilder();
        BufferedReader br = null;
        String separator = System.getProperty("line.separator", "\n");
        try {
            String line;
            InputStream is = Bootstrap.class.getResourceAsStream("logo.txt");
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                logo.append(line).append(separator);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        System.out.println(logo.toString());
    }
}

