/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.dispatcher;

import com.rodbate.httpserver.dispatcher.AbstractRequestDispatcher;
import com.rodbate.httpserver.http.RBHttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRequestDispatcher
extends AbstractRequestDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRequestDispatcher.class);

    @Override
    public void init() {
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        LOGGER.info("The remote address is {}", (Object)socketAddress.getHostName());
        super.channelActive(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof RBHttpRequest) {
            RBHttpRequest request = (RBHttpRequest)msg;
            String uri = request.uri();
            ByteBuf content = Unpooled.copiedBuffer((byte[])(uri + "response").getBytes());
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
            response.headers().add("Content-Type", (Object)"application/json");
            response.headers().add("Content-Length", (Object)content.readableBytes());
            ctx.writeAndFlush((Object)response);
        }
    }

    protected abstract void dispatch() throws Exception;

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.error(cause.getMessage(), cause);
        ctx.channel().close();
    }
}

