/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.common;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ClassReflection {
    public static Set<Class<?>> getClassesFromPackage(ClassLoader classLoader, String pack) {
        Objects.requireNonNull(pack, "pack must not be null");
        HashSet classSet = new HashSet();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        String packagePath = "";
        if (pack.length() > 0) {
            packagePath = pack.replace(".", "/");
        }
        try {
            Enumeration<URL> resources = classLoader.getResources(packagePath);
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                String protocol = url.getProtocol();
                if (!"file".equals(protocol)) continue;
                String fileName = URLDecoder.decode(url.getFile(), "UTF-8");
                ClassReflection.findClass(pack, fileName, classSet, classLoader);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classSet;
    }

    private static void findClass(String pack, String fileName, Set<Class<?>> classSet, ClassLoader classLoader) {
        File[] files;
        File dir = new File(fileName);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File f : files = dir.listFiles(pathname -> pathname.isDirectory() || pathname.getName().endsWith(".class"))) {
            if (f.isDirectory()) {
                ClassReflection.findClass(pack.length() == 0 ? f.getName() : pack + "." + f.getName(), f.getAbsolutePath(), classSet, classLoader);
                continue;
            }
            String className = f.getName().substring(0, f.getName().length() - 6);
            try {
                classSet.add(classLoader.loadClass(pack.length() == 0 ? className : pack + "." + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public static Set<Class<?>> getClassesByAnnotation(Class<? extends Annotation> annotation) {
        HashSet classes = new HashSet();
        Set<Class<?>> classSet = ClassReflection.getClassesFromPackage(null, "");
        for (Class<?> clazz : classSet) {
            if (!clazz.isAnnotationPresent(annotation)) continue;
            classes.add(clazz);
        }
        return classes;
    }

    public static Set<Method> getMethodsByClassAndAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        Method[] declaredMethods;
        HashSet<Method> methods = new HashSet<Method>();
        for (Method m : declaredMethods = clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(annotation)) continue;
            methods.add(m);
        }
        return methods;
    }

    public static Set<Method> getMethodsByAnnotation(Class<? extends Annotation> annotation) {
        HashSet<Method> methods = new HashSet<Method>();
        Set<Class<?>> classSet = ClassReflection.getClassesFromPackage(null, "");
        for (Class<?> clazz : classSet) {
            Method[] declaredMethods;
            for (Method m : declaredMethods = clazz.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(annotation)) continue;
                methods.add(m);
            }
        }
        return methods;
    }
}

