/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.http;

import com.rodbate.httpserver.common.ServerConstants;
import com.rodbate.httpserver.common.StringUtil;
import com.rodbate.httpserver.http.RBHttpRequest;
import com.rodbate.httpserver.http.RBHttpResponse;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileHandler.class);

    public static boolean download(ChannelHandlerContext ctx, RBHttpRequest request, String filePath) {
        RBHttpResponse response;
        long transferLength;
        long startPos;
        long fileLength;
        RandomAccessFile raf;
        File file = new File(filePath);
        if (file.isHidden() || !file.exists()) {
            return false;
        }
        String ifModifiedSince = request.getHeaderByName("If-Modified-Since");
        if (StringUtil.isNotNull(ifModifiedSince)) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss zzz", Locale.US);
            try {
                Date ifModifiedSinceDate = sdf.parse(ifModifiedSince);
                if (ifModifiedSinceDate.getTime() / 1000L == file.lastModified() / 1000L) {
                    FileHandler.sendNotModified(ctx);
                    return true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        try {
            fileLength = raf.length();
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
        String requestRange = request.getHeaderByName("Range");
        if (StringUtil.isNotNull(requestRange)) {
            long endPos;
            String str = requestRange.trim().split("=")[1];
            startPos = Long.valueOf(str.split("-")[0]);
            if (str.split("-").length == 2) {
                endPos = Long.valueOf(str.split("-")[1]);
                if (endPos + 1L > fileLength) {
                    endPos = fileLength - 1L;
                }
            } else {
                endPos = fileLength - 1L;
            }
            transferLength = endPos - startPos + 1L;
            response = new RBHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PARTIAL_CONTENT);
            response.setHeader("Content-Range", String.format("bytes %d-%d/%d", startPos, endPos, transferLength));
        } else {
            startPos = 0L;
            long endPos = fileLength - 1L;
            transferLength = fileLength;
            response = new RBHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        }
        response.setHeader("Content-Length", transferLength);
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            response.setHeader("Connection", "keep-alive");
        }
        response.setHeader("Content-Type", "application/octet-stream");
        FileHandler.setDateAndCacheHeader(response, file);
        try {
            ctx.pipeline().addBefore("dispatcher", "chunkWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("========== .>>>>>>>  chunkWriter handler exists");
        }
        ctx.channel().write((Object)response);
        ChannelFuture sendFileFuture = ctx.channel().write((Object)new DefaultFileRegion(raf.getChannel(), startPos, transferLength), (ChannelPromise)ctx.newProgressivePromise());
        ChannelFuture lastContentFuture = ctx.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                if (total < 0L) {
                    LOGGER.info("{} Transfer progress: {}", (Object)future.channel(), (Object)progress);
                } else {
                    LOGGER.info("{} Transfer progress: {} / {}", new Object[]{future.channel(), progress, total});
                }
            }

            public void operationComplete(ChannelProgressiveFuture future) {
                LOGGER.info("{}  Transfer complete.", (Object)future.channel());
            }
        });
        if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        ctx.pipeline().remove("chunkWriter");
        return true;
    }

    private static void setDateAndCacheHeader(RBHttpResponse response, File file) {
        GregorianCalendar c = new GregorianCalendar();
        response.setHeader("Date", ServerConstants.HTTP_SIMPLE_DATE_FORMATTER.format(c.getTime()));
        ((Calendar)c).add(13, 600);
        response.setHeader("Expires", ServerConstants.HTTP_SIMPLE_DATE_FORMATTER.format(c.getTime()));
        response.setHeader("Cache-Control", "private, max-age=600");
        response.setHeader("Last-Modified", ServerConstants.HTTP_SIMPLE_DATE_FORMATTER.format(new Date(file.lastModified())));
    }

    private static void sendNotModified(ChannelHandlerContext ctx) {
        RBHttpResponse response = new RBHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED);
        response.setHeader("Date", ServerConstants.HTTP_SIMPLE_DATE_FORMATTER.format(new Date()));
        response.setHeader("Connection", "close");
        ctx.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

