/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.api.processor.helper.retry;

import com.github.salilvnair.api.processor.helper.retry.RetryExecutorException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int maxRetries = 0;
    private long delay = 0L;
    private List<String> whiteListedExceptions;

    public RetryExecutor maxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public RetryExecutor delay(long delayInMillis) {
        this.delay = delayInMillis;
        return this;
    }

    public RetryExecutor maxRetries(String maxRetries) {
        if (StringUtils.isNotEmpty((String)maxRetries) && NumberUtils.isNumber((String)(maxRetries = maxRetries.trim()))) {
            this.maxRetries = Integer.parseInt(maxRetries);
        }
        return this;
    }

    public RetryExecutor delay(String delay, TimeUnit timeUnit) {
        if (StringUtils.isNotEmpty((String)delay) && NumberUtils.isNumber((String)(delay = delay.trim()))) {
            this.delay = timeUnit.toMillis(Integer.parseInt(delay));
        }
        return this;
    }

    public RetryExecutor configure(String exception) {
        if (this.whiteListedExceptions == null) {
            this.whiteListedExceptions = new ArrayList<String>();
        }
        this.whiteListedExceptions.add(exception);
        return this;
    }

    public RetryExecutor configure(List<String> exceptions) {
        if (this.whiteListedExceptions == null) {
            this.whiteListedExceptions = new ArrayList<String>();
        }
        if (CollectionUtils.isNotEmpty(exceptions)) {
            this.whiteListedExceptions.addAll(exceptions);
        }
        return this;
    }

    public RetryExecutor delay(int delay, TimeUnit timeUnit) {
        this.delay = timeUnit.toMillis(delay);
        return this;
    }

    public <T, R> T execute(Supplier<T> function) throws RetryExecutorException {
        try {
            return function.get();
        }
        catch (Exception e) {
            boolean foundWhiteListedException;
            if (this.whiteListedExceptions != null && !this.whiteListedExceptions.isEmpty() && !(foundWhiteListedException = this.whiteListedExceptions.stream().anyMatch(exception -> e.getLocalizedMessage() != null && e.getLocalizedMessage().contains((CharSequence)exception)))) {
                String retryExecutorMsg = "FAILED will not be retried as the exception is not whitelisted";
                this.logger.error("{} ex:{}", (Object)retryExecutorMsg, (Object)e.getLocalizedMessage());
                throw new RetryExecutorException(e, retryExecutorMsg, e.getLocalizedMessage());
            }
            this.logger.error(e.getLocalizedMessage());
            this.logger.error("FAILED will be retried {} times after a delay of {} seconds.", (Object)this.maxRetries, (Object)TimeUnit.MILLISECONDS.toSeconds(this.delay));
            return this.retry(function);
        }
    }

    private <T> T retry(Supplier<T> function) throws RetryExecutorException {
        Throwable exception = null;
        int retryCounter = 0;
        while (retryCounter < this.maxRetries) {
            try {
                if (this.delay > 0L) {
                    Thread.sleep(this.delay);
                }
                return function.get();
            }
            catch (Exception ex) {
                this.logger.error(ex.getLocalizedMessage());
                this.logger.error("FAILED on retry {} of {}", (Object)(++retryCounter), (Object)this.maxRetries);
                if (retryCounter < this.maxRetries) continue;
                this.logger.error("Max retries exceeded.");
                exception = ex;
                break;
            }
        }
        if (exception == null) {
            throw new RetryExecutorException("FAILED on all of " + this.maxRetries + " retries");
        }
        throw new RetryExecutorException(exception, "FAILED on all of " + this.maxRetries + " retries", exception.getLocalizedMessage());
    }
}

