/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.api.processor.soap.delegate;

import com.github.salilvnair.api.processor.soap.callback.SoapWebServiceRequestCallback;
import com.github.salilvnair.api.processor.soap.callback.SoapWebServiceResponseCallback;
import com.github.salilvnair.api.processor.soap.exception.SoapWebServiceException;
import com.github.salilvnair.api.processor.soap.model.SoapWebServiceRequest;
import com.github.salilvnair.api.processor.soap.model.SoapWebServiceResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;
import org.springframework.ws.FaultAwareWebServiceMessage;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.soap.client.SoapFaultClientException;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.support.MarshallingUtils;

public interface SoapWebServiceDelegate {
    public static final String LOG_TYPE_REQUEST = "REQUEST";
    public static final String LOG_TYPE_RESPONSE = "RESPONSE";
    public static final String SOAP_REQUEST = "SOAP_REQUEST";
    public static final String SOAP_RESPONSE = "SOAP_RESPONSE";
    public static final String SOAP_REQUEST_HEADERS = "SOAP_REQUEST_HEADERS";
    public static final String SOAP_RESPONSE_HEADERS = "SOAP_RESPONSE_HEADERS";
    public static final String SOAP_ERROR_STRING = "SOAP_ERROR_STRING";
    public static final String RESPONSE_STATUS_CODE = "RESPONSE_STATUS_CODE";

    default public void addHeaders(SOAPHeader soapHeader, Map<String, Object> wsParamsMap) throws SOAPException {
    }

    public WebServiceTemplate webServiceTemplate();

    default public void doMoreWithRequest(WebServiceMessage webServiceMessage, Map<String, Object> wsParamsMap) {
    }

    default public void doMoreWithResponse(WebServiceMessage webServiceMessage, Map<String, Object> wsParamsMap) {
    }

    public SoapWebServiceResponse invoke(SoapWebServiceRequest var1, Map<String, Object> var2, Object ... var3) throws SoapWebServiceException;

    default public boolean retry() {
        return false;
    }

    default public List<String> whiteListedExceptions() {
        return Collections.emptyList();
    }

    default public int delay() {
        return 0;
    }

    default public int maxRetries() {
        return 0;
    }

    default public TimeUnit delayTimeUnit() {
        return TimeUnit.MINUTES;
    }

    public String webServiceName();

    default public boolean printLogs() {
        return true;
    }

    default public <T> T marshalSendAndReceive(SoapWebServiceRequest requestWrapper, Map<String, Object> wsParamsMap) throws SoapWebServiceException {
        return this.marshalSendAndReceive(requestWrapper, wsParamsMap, new SoapWebServiceRequestCallback(this, wsParamsMap), new SoapWebServiceResponseCallback(this, wsParamsMap));
    }

    default public <T> T marshalSendAndReceive(SoapWebServiceRequest requestWrapper, Map<String, Object> wsParamsMap, SoapWebServiceRequestCallback requestCallback, SoapWebServiceResponseCallback<T> responseExtractor) throws SoapWebServiceException {
        Object t;
        try {
            t = this.webServiceTemplate().sendAndReceive(webServiceMessage -> {
                if (requestWrapper != null) {
                    Marshaller marshaller = this.webServiceTemplate().getMarshaller();
                    if (marshaller == null) {
                        throw new IllegalStateException("No marshaller registered. Check configuration of WebServiceTemplate.");
                    }
                    MarshallingUtils.marshal((Marshaller)marshaller, (Object)requestWrapper.request(), (WebServiceMessage)webServiceMessage);
                    requestCallback.doWithMessage(webServiceMessage);
                }
            }, responseExtractor);
        }
        catch (Exception ex) {
            if (ex instanceof SoapFaultClientException) {
                FaultAwareWebServiceMessage webServiceMessage2 = ((SoapFaultClientException)ex).getWebServiceMessage();
                Map<String, Object> responseHeaders = SoapWebServiceDelegate.extractHeaders((WebServiceMessage)webServiceMessage2);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    webServiceMessage2.writeTo((OutputStream)byteArrayOutputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String faultString = byteArrayOutputStream.toString();
                if (wsParamsMap != null) {
                    wsParamsMap.put(SOAP_RESPONSE_HEADERS, responseHeaders);
                    wsParamsMap.put(SOAP_ERROR_STRING, faultString);
                    wsParamsMap.put(RESPONSE_STATUS_CODE, 500);
                }
                throw new SoapWebServiceException((Throwable)ex, this.webServiceName(), faultString);
            }
            if (wsParamsMap != null && wsParamsMap.containsKey(SOAP_ERROR_STRING)) {
                throw new SoapWebServiceException((Throwable)ex, this.webServiceName(), String.valueOf(wsParamsMap.get(SOAP_ERROR_STRING)));
            }
            throw new SoapWebServiceException(ex, this.webServiceName());
        }
        return (T)t;
    }

    public static Map<String, Object> extractHeaders(WebServiceMessage webServiceMessage) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        MimeHeaders mimeHeaders = ((SaajSoapMessage)webServiceMessage).getSaajMessage().getMimeHeaders();
        if (mimeHeaders != null) {
            Iterator allMimeHeaders = mimeHeaders.getAllHeaders();
            while (allMimeHeaders.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)allMimeHeaders.next();
                headers.put(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
        return headers;
    }

    public static WebServiceTemplate webServiceTemplate(String contextPath, String endpointUrl) {
        Jaxb2Marshaller jaxb2Marshaller = new Jaxb2Marshaller();
        jaxb2Marshaller.setContextPath(contextPath);
        WebServiceTemplate webServiceTemplate = new WebServiceTemplate();
        webServiceTemplate.setMarshaller((Marshaller)jaxb2Marshaller);
        webServiceTemplate.setUnmarshaller((Unmarshaller)jaxb2Marshaller);
        webServiceTemplate.setDefaultUri(endpointUrl);
        return webServiceTemplate;
    }
}

