/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.api.processor.soap.delegate.resolver;

import com.github.salilvnair.api.processor.helper.reflection.ReflectionUtil;
import com.github.salilvnair.api.processor.soap.delegate.resolver.core.SoapWebServiceHeader;
import com.github.salilvnair.api.processor.soap.delegate.resolver.reflect.SoapHeader;
import com.github.salilvnair.api.processor.soap.delegate.resolver.reflect.SoapHeaderAttribute;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import org.springframework.stereotype.Component;

@Component
public class SoapHeaderResolver {
    public void resolve(Object source, SOAPHeader soapHeader, Map<String, Object> wsParamsMap) throws SOAPException {
        this.resolve(source, soapHeader, wsParamsMap, null);
    }

    private void resolve(Object source, SOAPHeader soapHeader, Map<String, Object> wsParamsMap, SOAPElement soapElement) throws SOAPException {
        if (source.getClass().isAnnotationPresent(SoapHeader.class)) {
            SOAPElement nestedElement;
            SoapHeader classAnnotation = source.getClass().getAnnotation(SoapHeader.class);
            if (soapElement == null) {
                nestedElement = soapElement = soapHeader.addChildElement(classAnnotation.name(), classAnnotation.namespace(), classAnnotation.namespaceUri());
            } else {
                nestedElement = soapElement.addChildElement(classAnnotation.name(), classAnnotation.namespace());
                if (!"".equals(classAnnotation.qNamespace()) && !"".equals(classAnnotation.qNamespaceUri())) {
                    nestedElement.addAttribute(new QName("xmlns:" + classAnnotation.qNamespace()), classAnnotation.qNamespaceUri());
                }
            }
            Set<Field> fields = ReflectionUtil.findFields(source.getClass());
            for (Field field : fields) {
                Object fieldValue;
                if (!field.isAnnotationPresent(SoapHeader.class)) continue;
                if (field.getType() == String.class && nestedElement != null) {
                    this.resolve(field, source, soapHeader, wsParamsMap, nestedElement);
                    continue;
                }
                if (!SoapWebServiceHeader.class.isAssignableFrom(field.getType()) || (fieldValue = ReflectionUtil.findFieldValue(source, field)) == null) continue;
                this.resolve(fieldValue, soapHeader, wsParamsMap, nestedElement);
            }
        }
    }

    private void resolve(Field field, Object source, SOAPHeader soapHeader, Map<String, Object> wsParamsMap, SOAPElement soapElement) throws SOAPException {
        SoapHeader fieldAnnotation = field.getAnnotation(SoapHeader.class);
        SOAPElement textNodeElement = soapElement.addChildElement(fieldAnnotation.name(), fieldAnnotation.namespace());
        for (SoapHeaderAttribute soapHeaderAttribute : fieldAnnotation.attributes()) {
            textNodeElement.setAttribute(soapHeaderAttribute.name(), soapHeaderAttribute.value());
        }
        textNodeElement.addTextNode((String)ReflectionUtil.findFieldValue(source, field));
    }
}

