/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.api.processor.soap.callback;

import com.github.salilvnair.api.processor.soap.delegate.SoapWebServiceDelegate;
import com.github.salilvnair.api.processor.soap.log.SoapWebServiceLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.springframework.oxm.Unmarshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageExtractor;
import org.springframework.ws.support.MarshallingUtils;

public class SoapWebServiceResponseCallback<T>
implements WebServiceMessageExtractor<T> {
    private final SoapWebServiceDelegate delegate;
    private final Map<String, Object> wsParamsMap;

    public SoapWebServiceResponseCallback(SoapWebServiceDelegate delegate, Map<String, Object> wsParamsMap) {
        this.delegate = delegate;
        this.wsParamsMap = wsParamsMap;
    }

    public T extractData(WebServiceMessage webServiceMessage) throws IOException {
        Map<String, Object> responseHeaders = SoapWebServiceDelegate.extractHeaders(webServiceMessage);
        this.wsParamsMap.put("SOAP_RESPONSE_HEADERS", responseHeaders);
        this.delegate.doMoreWithResponse(webServiceMessage, this.wsParamsMap);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        webServiceMessage.writeTo((OutputStream)byteArrayOutputStream);
        String responseString = byteArrayOutputStream.toString();
        this.wsParamsMap.put("SOAP_RESPONSE", responseString);
        this.wsParamsMap.put("RESPONSE_STATUS_CODE", 200);
        if (this.delegate.printLogs()) {
            SoapWebServiceLogger.printLogs(responseString, this.delegate, "RESPONSE");
        }
        Object object = null;
        try {
            object = MarshallingUtils.unmarshal((Unmarshaller)this.delegate.webServiceTemplate().getUnmarshaller(), (WebServiceMessage)webServiceMessage);
        }
        catch (Exception ex) {
            this.wsParamsMap.put("SOAP_RESPONSE_HEADERS", responseHeaders);
            this.wsParamsMap.put("SOAP_ERROR_STRING", responseString);
            throw new RuntimeException(ex);
        }
        return (T)object;
    }
}

