/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.api.processor.helper.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public class ReflectionUtil {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    public static Method findSetterMethod(Class<?> clazz, String propertyName, Class<?> parameterType) {
        String setterMethodName = SETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        return ReflectionUtil.findMethod(clazz, setterMethodName, parameterType);
    }

    public static Method findGetterMethod(Class<?> clazz, String propertyName) {
        String getterMethodName = GETTER_PREFIX + StringUtils.capitalize((String)propertyName);
        Method method = ReflectionUtil.findMethod(clazz, getterMethodName, new Class[0]);
        if (method == null) {
            getterMethodName = IS_PREFIX + StringUtils.capitalize((String)propertyName);
            method = ReflectionUtil.findMethod(clazz, getterMethodName, new Class[0]);
        }
        return method;
    }

    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Method method = MethodUtils.getMatchingMethod(clazz, (String)methodName, (Class[])parameterTypes);
        if (method != null) {
            ReflectionUtil.makeAccessible(method);
        }
        return method;
    }

    public static Method findAccessibleMethodByName(Class<?> clazz, String methodName) {
        Validate.notNull(clazz, (String)"clazz can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)methodName, (String)"methodName can't be blank", (Object[])new Object[0]);
        for (Class<?> searchType = clazz; searchType != Object.class; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                ReflectionUtil.makeAccessible(method);
                return method;
            }
        }
        return null;
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        Validate.notNull(clazz, (String)"clazz can't be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)fieldName, (String)"fieldName can't be blank", (Object[])new Object[0]);
        for (Class<?> superClass = clazz; superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                Field field = superClass.getDeclaredField(fieldName);
                ReflectionUtil.makeAccessible(field);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static <T> T invokeGetter(Object obj, String propertyName) {
        Method method = ReflectionUtil.findGetterMethod(obj.getClass(), propertyName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + String.valueOf(obj) + "]");
        }
        return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
    }

    public static void invokeSetter(Object obj, String propertyName, Object value) {
        Method method = ReflectionUtil.findSetterMethod(obj.getClass(), propertyName, value.getClass());
        if (method == null) {
            throw new IllegalArgumentException("Could not find getter method [" + propertyName + "] on target [" + String.valueOf(obj) + "]");
        }
        ReflectionUtil.invokeMethod(obj, method, value);
    }

    public static <T> T findFieldValue(Object obj, String fieldName) {
        Field field = ReflectionUtil.findField(obj.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + String.valueOf(obj) + "]");
        }
        return ReflectionUtil.findFieldValue(obj, field);
    }

    public static <T> T findFieldValue(Object obj, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void setFieldValue(Object obj, String fieldName, Object value) {
        Field field = ReflectionUtil.findField(obj.getClass(), fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Could not find field [" + fieldName + "] on target [" + String.valueOf(obj) + "]");
        }
        ReflectionUtil.setField(obj, field, value);
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            ReflectionUtil.makeAccessible(field);
            field.set(obj, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> T findProperty(Object obj, String propertyName) {
        Method method = ReflectionUtil.findGetterMethod(obj.getClass(), propertyName);
        if (method != null) {
            return ReflectionUtil.invokeMethod(obj, method, new Object[0]);
        }
        return ReflectionUtil.findFieldValue(obj, propertyName);
    }

    public static void setProperty(Object obj, String propertyName, Object value) {
        Method method = ReflectionUtil.findSetterMethod(obj.getClass(), propertyName, value.getClass());
        if (method != null) {
            ReflectionUtil.invokeMethod(obj, method, value);
        } else {
            ReflectionUtil.setFieldValue(obj, propertyName, value);
        }
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object ... args) {
        Object[] theArgs = ArrayUtils.nullToEmpty((Object[])args);
        Class[] parameterTypes = ClassUtils.toClass((Object[])theArgs);
        return ReflectionUtil.invokeMethod(obj, methodName, theArgs, parameterTypes);
    }

    public static <T> T invokeMethod(Object obj, String methodName, Object[] args, Class<?>[] parameterTypes) {
        Method method = ReflectionUtil.findMethod(obj.getClass(), methodName, parameterTypes);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] with parameter types:" + Arrays.toString(parameterTypes));
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethodByName(Object obj, String methodName, Object[] args) {
        Method method = ReflectionUtil.findAccessibleMethodByName(obj.getClass(), methodName);
        if (method == null) {
            throw new IllegalArgumentException("Could not find method [" + methodName + "] on class [" + String.valueOf(obj.getClass()) + "]");
        }
        return ReflectionUtil.invokeMethod(obj, method, args);
    }

    public static <T> T invokeMethod(Object obj, Method method, Object ... args) {
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T invokeMethodAndThrowException(Object obj, Method method, Object ... args) throws Exception {
        return (T)method.invoke(obj, args);
    }

    public static <T> T invokeConstructor(Class<T> cls, Object ... args) {
        try {
            return (T)ConstructorUtils.invokeConstructor(cls, (Object[])args);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void makeAccessible(Method method) {
        if (!(method.isAccessible() || Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()))) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Field field) {
        if (!(field.isAccessible() || Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()))) {
            field.setAccessible(true);
        }
    }

    public static Set<Field> findFields(Class<?> clazz) {
        return new LinkedHashSet<Field>(Arrays.asList(clazz.getDeclaredFields()));
    }

    public static Set<Field> findFields(Class<?> clazz, boolean searchInAllSuperClass) {
        HashSet<Field> fields = new HashSet<Field>();
        if (!searchInAllSuperClass) {
            return ReflectionUtil.findFields(clazz);
        }
        while (clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    public static boolean hasField(Object obj, String fieldName) {
        return ReflectionUtil.findField(obj.getClass(), fieldName) != null;
    }

    public static boolean hasField(Object obj, Field field) {
        return ReflectionUtil.findField(obj.getClass(), field.getName()) != null;
    }

    public static Class<?> findParameterizedType(Object object, String fieldName) {
        Field field = ReflectionUtil.findField(object.getClass(), fieldName);
        return field == null ? null : ReflectionUtil.findParameterizedType(object, field);
    }

    public static Class<?> findParameterizedType(Object object, Field field) {
        ParameterizedType stringListType = (ParameterizedType)field.getGenericType();
        return (Class)stringListType.getActualTypeArguments()[0];
    }

    public static Class<?> findType(Object object, String fieldName) {
        Field field = ReflectionUtil.findField(object.getClass(), fieldName);
        return field == null ? null : ReflectionUtil.findType(object, field);
    }

    public static Class<?> findType(Object object, Field field) {
        return field.getType();
    }

    public static <T> T createInstance(Class<T> clazz) throws Exception {
        Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }
}

