/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.api.processor.soap.callback;

import com.github.salilvnair.api.processor.soap.delegate.SoapWebServiceDelegate;
import com.github.salilvnair.api.processor.soap.log.SoapWebServiceLogger;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.client.core.WebServiceMessageCallback;
import org.springframework.ws.soap.saaj.SaajSoapMessage;

public class SoapWebServiceRequestCallback
implements WebServiceMessageCallback {
    private final SoapWebServiceDelegate delegate;
    private final Map<String, Object> wsParamsMap;

    public SoapWebServiceRequestCallback(SoapWebServiceDelegate delegate, Map<String, Object> wsParamsMap) {
        this.delegate = delegate;
        this.wsParamsMap = wsParamsMap;
    }

    public void doWithMessage(WebServiceMessage webServiceMessage) throws IOException {
        SOAPMessage saajSoapMessage = ((SaajSoapMessage)webServiceMessage).getSaajMessage();
        try {
            SOAPEnvelope envelope = saajSoapMessage.getSOAPPart().getEnvelope();
            SOAPHeader soapHeader = saajSoapMessage.getSOAPHeader();
            if (soapHeader == null) {
                envelope.addHeader();
            }
            this.delegate.addHeaders(soapHeader, this.wsParamsMap);
        }
        catch (SOAPException e) {
            throw new RuntimeException(e);
        }
        this.delegate.doMoreWithRequest(webServiceMessage, this.wsParamsMap);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        webServiceMessage.writeTo((OutputStream)byteArrayOutputStream);
        String requestString = byteArrayOutputStream.toString();
        this.wsParamsMap.put("SOAP_REQUEST", requestString);
        Map<String, Object> requestHeaders = SoapWebServiceDelegate.extractHeaders(webServiceMessage);
        this.wsParamsMap.put("SOAP_REQUEST_HEADERS", requestHeaders);
        if (this.delegate.printLogs()) {
            SoapWebServiceLogger.printLogs(requestString, this.delegate, "REQUEST");
        }
    }

    public Map<String, Object> wsParamsMap() {
        return this.wsParamsMap;
    }
}

