/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.jsonprocessor.path.builder;

import java.util.ArrayList;
import java.util.List;

public class JsonPathBuilder {
    private static final String JSON_PATH_EXPR_SELECT_PLACEHOLDER = "<SELECT>";
    public static final String JSON_PATH_EXPR_DOT = ".";
    public static final String JSON_PATH_EXPR_SELECT_ALL = "*";
    public static final String JSON_PATH_EXPR_ARRAYNODE_OPEN = "[";
    public static final String JSON_PATH_EXPR_ARRAYNODE_CLOSE = "]";
    private static final String JSON_PATH_EXPR_WHERE_PLACEHOLDER = "<WHERE>";
    private static final String JSON_PATH_EXPR_IS_PLACEHOLDER = "<IS>";
    private static final String JSON_PATH_EXPR_WHERE_IS_PLACEHOLDER = "(@.<WHERE> == <IS>)";
    private static final String JSON_PATH_EXPR_LIST_IS_PLACEHOLDER = "(@ == <IS>)";
    private static final String JSON_PATH_EXPR_QUERY_PLACEHOLDER = "?";
    private static final String JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER = "==";
    private static final String JSON_PATH_EXPR_LESS_THAN_QUERY_PLACEHOLDER = "<";
    private static final String JSON_PATH_EXPR_LESS_THAN_EQUAL_QUERY_PLACEHOLDER = "<=";
    private static final String JSON_PATH_EXPR_GREATER_THAN_QUERY_PLACEHOLDER = ">";
    private static final String JSON_PATH_EXPR_GREATER_THAN_EQUAL_QUERY_PLACEHOLDER = ">=";
    private static final String JSON_PATH_EXPR_NOT_EQUAL_QUERY_PLACEHOLDER = "!=";
    private static final String JSON_PATH_EXPR_REGEX_QUERY_PLACEHOLDER = "=~";
    private static final String JSON_PATH_EXPR_IN_QUERY_PLACEHOLDER = "in";
    private static final String JSON_PATH_EXPR_NOT_IN_QUERY_PLACEHOLDER = "nin";
    private static final String JSON_PATH_EXPR_QUERY_PLACEHOLDER_MULTICONDTION_OPEN = "?(";
    private static final String JSON_PATH_EXPR_QUERY_PLACEHOLDER_MULTICONDTION_CLOSE = ")";
    private final StringBuilder jsonPathExpressionString = new StringBuilder("$");
    private boolean hasMultipleConditions;
    private boolean isArrayNodeOfData;
    private final List<String> arrayNodeConditions = new ArrayList<String>(5){
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            StringBuilder arrayNodeConditionBuilder = new StringBuilder(JsonPathBuilder.JSON_PATH_EXPR_ARRAYNODE_OPEN);
            if (JsonPathBuilder.this.hasMultipleConditions) {
                arrayNodeConditionBuilder.append(JsonPathBuilder.JSON_PATH_EXPR_QUERY_PLACEHOLDER_MULTICONDTION_OPEN);
            } else {
                arrayNodeConditionBuilder.append(JsonPathBuilder.JSON_PATH_EXPR_QUERY_PLACEHOLDER);
            }
            for (String condition : JsonPathBuilder.this.arrayNodeConditions) {
                arrayNodeConditionBuilder.append(condition);
            }
            if (JsonPathBuilder.this.hasMultipleConditions) {
                arrayNodeConditionBuilder.append(JsonPathBuilder.JSON_PATH_EXPR_QUERY_PLACEHOLDER_MULTICONDTION_CLOSE);
            }
            arrayNodeConditionBuilder.append(JsonPathBuilder.JSON_PATH_EXPR_ARRAYNODE_CLOSE);
            return arrayNodeConditionBuilder.toString();
        }
    };
    private final StringBuilder selectWhere = new StringBuilder("(@.<WHERE> == <IS>)");

    public JsonPathBuilder objectnode(Object ... parameters) {
        Object key = null;
        if (parameters.length != 0) {
            key = parameters[0];
        }
        if (key != null) {
            this.jsonPathExpressionString.append(JSON_PATH_EXPR_DOT).append(key);
        } else {
            this.jsonPathExpressionString.append(JSON_PATH_EXPR_DOT);
        }
        return this;
    }

    public JsonPathBuilder any() {
        return this.objectnode(new Object[0]);
    }

    public JsonPathBuilder key(String key) {
        this.objectnode(key);
        return this;
    }

    public JsonPathBuilder arraynode(Object ... parameters) {
        boolean arrayNodeInCondition;
        boolean arrayNodeOfData;
        Object key = null;
        this.isArrayNodeOfData = false;
        if (parameters.length != 0) {
            key = parameters[0];
        }
        if (!this.arrayNodeConditions.isEmpty()) {
            this.buildNode();
        }
        this.arrayNodeConditions.clear();
        if (key != null) {
            this.jsonPathExpressionString.append(JSON_PATH_EXPR_DOT).append(key).append(JSON_PATH_EXPR_SELECT_PLACEHOLDER);
        } else {
            this.jsonPathExpressionString.append(".<SELECT>");
        }
        if (parameters.length > 1 && parameters[1] != null && (arrayNodeOfData = ((Boolean)parameters[1]).booleanValue())) {
            this.isArrayNodeOfData = true;
        }
        if (parameters.length > 2 && parameters[1] != null && parameters[2] != null && (arrayNodeInCondition = ((Boolean)parameters[1]).booleanValue())) {
            this.jsonPathExpressionString.setLength(0);
            this.jsonPathExpressionString.append(key).append(JSON_PATH_EXPR_SELECT_PLACEHOLDER);
        }
        return this;
    }

    private void buildNode() {
        if (this.arrayNodeConditions.isEmpty()) {
            return;
        }
        if (this.arrayNodeConditions.size() > 1) {
            this.hasMultipleConditions = true;
        }
        int position = this.jsonPathExpressionString.lastIndexOf(JSON_PATH_EXPR_SELECT_PLACEHOLDER);
        this.jsonPathExpressionString.replace(position, position + JSON_PATH_EXPR_SELECT_PLACEHOLDER.length(), this.arrayNodeConditions.toString());
    }

    public JsonPathBuilder select(Object ... parameters) {
        Object key = null;
        if (parameters.length != 0 && (JSON_PATH_EXPR_SELECT_ALL.equals(key = parameters[0]) || key instanceof Integer)) {
            int position = this.jsonPathExpressionString.lastIndexOf(JSON_PATH_EXPR_SELECT_PLACEHOLDER);
            this.jsonPathExpressionString.replace(position, position + JSON_PATH_EXPR_SELECT_PLACEHOLDER.length(), JSON_PATH_EXPR_ARRAYNODE_OPEN + key + JSON_PATH_EXPR_ARRAYNODE_CLOSE + "");
        }
        this.selectWhere.setLength(0);
        if (this.isArrayNodeOfData) {
            this.selectWhere.append(JSON_PATH_EXPR_LIST_IS_PLACEHOLDER);
        } else {
            this.selectWhere.append(JSON_PATH_EXPR_WHERE_IS_PLACEHOLDER);
        }
        return this;
    }

    public JsonPathBuilder selectAll() {
        return this.select(JSON_PATH_EXPR_SELECT_ALL);
    }

    public JsonPathBuilder where(Object ... parameters) {
        String key = (String)parameters[0];
        boolean reverseCondition = false;
        if (parameters.length > 1 && parameters[1] != null) {
            reverseCondition = (Boolean)parameters[1];
        }
        if (reverseCondition) {
            this.selectWhere.setLength(0);
            this.selectWhere.append("(<WHERE> == @.<IS>)");
        }
        int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_WHERE_PLACEHOLDER);
        this.selectWhere.replace(position, position + JSON_PATH_EXPR_WHERE_PLACEHOLDER.length(), key);
        return this;
    }

    public JsonPathBuilder is(Object ... parameters) {
        Object key = parameters[0];
        boolean forceNonString = false;
        if (parameters.length > 1 && parameters[1] != null) {
            forceNonString = (Boolean)parameters[1];
        }
        int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_IS_PLACEHOLDER);
        if (forceNonString) {
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_IS_PLACEHOLDER.length(), key + "");
        } else if (key instanceof String) {
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_IS_PLACEHOLDER.length(), "\"" + key.toString() + "\"");
        } else {
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_IS_PLACEHOLDER.length(), key + "");
        }
        this.arrayNodeConditions.add(this.selectWhere.toString());
        return this;
    }

    public JsonPathBuilder lt(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_LESS_THAN_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    public JsonPathBuilder lte(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_LESS_THAN_EQUAL_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    public JsonPathBuilder gt(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_GREATER_THAN_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    public JsonPathBuilder gte(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_GREATER_THAN_EQUAL_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    public JsonPathBuilder ne(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_NOT_EQUAL_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    public JsonPathBuilder regex(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_REGEX_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    public JsonPathBuilder in(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_IN_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    public JsonPathBuilder nin(Object ... parameters) {
        Object key = parameters[0];
        this.replaceOperationPlaceHolder(JSON_PATH_EXPR_NOT_IN_QUERY_PLACEHOLDER);
        if (parameters.length > 1 && parameters[1] != null) {
            return this.is(key, parameters[1]);
        }
        return this.is(key);
    }

    private void replaceOperationPlaceHolder(String queryPlaceHolder) {
        if (JSON_PATH_EXPR_LESS_THAN_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_LESS_THAN_QUERY_PLACEHOLDER);
        } else if (JSON_PATH_EXPR_LESS_THAN_EQUAL_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_LESS_THAN_EQUAL_QUERY_PLACEHOLDER);
        } else if (JSON_PATH_EXPR_GREATER_THAN_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_GREATER_THAN_QUERY_PLACEHOLDER);
        } else if (JSON_PATH_EXPR_GREATER_THAN_EQUAL_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_GREATER_THAN_EQUAL_QUERY_PLACEHOLDER);
        } else if (JSON_PATH_EXPR_NOT_EQUAL_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_NOT_EQUAL_QUERY_PLACEHOLDER);
        } else if (JSON_PATH_EXPR_REGEX_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_REGEX_QUERY_PLACEHOLDER);
        } else if (JSON_PATH_EXPR_IN_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_IN_QUERY_PLACEHOLDER);
        } else if (JSON_PATH_EXPR_NOT_IN_QUERY_PLACEHOLDER.equals(queryPlaceHolder)) {
            int position = this.selectWhere.lastIndexOf(JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER);
            this.selectWhere.replace(position, position + JSON_PATH_EXPR_EQUAL_QUERY_PLACEHOLDER.length(), JSON_PATH_EXPR_NOT_IN_QUERY_PLACEHOLDER);
        }
    }

    public JsonPathBuilder and() {
        this.arrayNodeConditions.add(" && ");
        this.selectWhere.setLength(0);
        if (this.isArrayNodeOfData) {
            this.selectWhere.append(JSON_PATH_EXPR_LIST_IS_PLACEHOLDER);
        } else {
            this.selectWhere.append(JSON_PATH_EXPR_WHERE_IS_PLACEHOLDER);
        }
        return this;
    }

    public JsonPathBuilder or() {
        this.arrayNodeConditions.add(" || ");
        this.selectWhere.setLength(0);
        if (this.isArrayNodeOfData) {
            this.selectWhere.append(JSON_PATH_EXPR_LIST_IS_PLACEHOLDER);
        } else {
            this.selectWhere.append(JSON_PATH_EXPR_WHERE_IS_PLACEHOLDER);
        }
        return this;
    }

    public JsonPathBuilder not() {
        this.arrayNodeConditions.add("!");
        this.selectWhere.setLength(0);
        if (this.isArrayNodeOfData) {
            this.selectWhere.append(JSON_PATH_EXPR_LIST_IS_PLACEHOLDER);
        } else {
            this.selectWhere.append(JSON_PATH_EXPR_WHERE_IS_PLACEHOLDER);
        }
        return this;
    }

    public String build() {
        this.buildNode();
        return this.jsonPathExpressionString.toString();
    }

    public String build(boolean clearString) {
        this.buildNode();
        String evaluatedExpression = this.jsonPathExpressionString.toString();
        if (clearString) {
            this.clear();
        }
        return evaluatedExpression;
    }

    public JsonPathBuilder clear() {
        this.jsonPathExpressionString.setLength(0);
        this.arrayNodeConditions.clear();
        this.selectWhere.setLength(0);
        this.jsonPathExpressionString.append("$");
        return this;
    }
}

