/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.jsonprocessor.path.helper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonPathUtil {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final Configuration configuration = this.getConfiguration();
    private ObjectMapper objectMapper;

    public Configuration getConfiguration() {
        return Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();
    }

    public DocumentContext add(Object jsonObject, String path, Object newData) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.add(jsonString, path, newData);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.add(jsonString, path, newData);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>add:DocumentContext>>caught exception:" + ex));
            return null;
        }
    }

    public String add(Object jsonObject, String path, Object newData, boolean returnJsonString) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.add(jsonString, path, newData, returnJsonString);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.add(jsonString, path, newData, returnJsonString);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>add:String>>caught exception:" + ex));
            return null;
        }
    }

    public <T> T add(Object jsonObject, String path, Object newData, TypeReference<T> typeRef) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.add(jsonString, path, newData, typeRef);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.add(jsonString, path, newData, typeRef);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>add:T(typeRef)>>caught exception:" + ex));
            return null;
        }
    }

    public DocumentContext add(String jsonString, String path, Object newData) {
        DocumentContext json = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        json.add(path, newData, new Predicate[0]);
        return json;
    }

    public <T> T add(String jsonString, String path, Object newData, TypeReference<T> typeRef) {
        DocumentContext parsedJson = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        parsedJson.add(path, newData, new Predicate[0]);
        Object finalJson = null;
        try {
            finalJson = this.getObjectMapper().readValue(parsedJson.jsonString(), typeRef);
        }
        catch (IOException ioex) {
            this.log.error((Object)("JsonPathUtil>>add:T(TypeReference)>>conversion error:" + ioex));
        }
        return (T)finalJson;
    }

    public String add(String jsonString, String path, Object newData, boolean returnJsonString) {
        if (returnJsonString) {
            return this.add(jsonString, path, newData).jsonString();
        }
        return null;
    }

    public DocumentContext put(Object jsonObject, String path, String key, Object newData) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.put(jsonString, path, key, newData);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.put(jsonString, path, key, newData);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>put:DocumentContext>>caught exception:" + ex));
            return null;
        }
    }

    public String put(Object jsonObject, String path, String key, Object newData, boolean returnJsonString) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.put(jsonString, path, key, newData, returnJsonString);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.put(jsonString, path, key, newData, returnJsonString);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>put:String>>caught exception:" + ex));
            return null;
        }
    }

    public <T> T put(Object jsonObject, String path, String key, Object newData, TypeReference<T> typeRef) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.put(jsonString, path, key, newData, typeRef);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.put(jsonString, path, key, newData, typeRef);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>add:T(typeRef)>>caught exception:" + ex));
            return null;
        }
    }

    public DocumentContext put(String jsonString, String path, String key, Object newData) {
        DocumentContext json = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        json.put(path, key, newData, new Predicate[0]);
        return json;
    }

    public <T> T put(String jsonString, String path, String key, Object newData, TypeReference<T> typeRef) {
        DocumentContext parsedJson = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        parsedJson.put(path, key, newData, new Predicate[0]);
        Object finalJson = null;
        try {
            finalJson = this.getObjectMapper().readValue(parsedJson.jsonString(), typeRef);
        }
        catch (IOException ioex) {
            this.log.error((Object)("JsonPathUtil>>add:T(TypeReference)>>conversion error:" + ioex));
        }
        return (T)finalJson;
    }

    public String put(String jsonString, String path, String key, Object newData, boolean returnJsonString) {
        if (returnJsonString) {
            return this.put(jsonString, path, key, newData).jsonString();
        }
        return null;
    }

    public DocumentContext set(Object jsonObject, String path, Object newData) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.set(jsonString, path, newData);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.set(jsonString, path, newData);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>set:DocumentContext>>caught exception:" + ex));
            return null;
        }
    }

    public String set(Object jsonObject, String path, Object newData, boolean returnJsonString) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.set(jsonString, path, newData, returnJsonString);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.set(jsonString, path, newData, returnJsonString);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>set:String>>caught exception:" + ex));
            return null;
        }
    }

    public <T> T set(Object jsonObject, String path, Object newData, TypeReference<T> typeRef) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.set(jsonString, path, newData, typeRef);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.set(jsonString, path, newData, typeRef);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>set:T(typeRef)>>caught exception:" + ex));
            return null;
        }
    }

    public <T> T set(String jsonString, String path, Object newData, TypeReference<T> typeRef) {
        DocumentContext parsedJson = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        parsedJson.set(path, newData, new Predicate[0]);
        Object finalJson = null;
        try {
            finalJson = this.getObjectMapper().readValue(parsedJson.jsonString(), typeRef);
        }
        catch (IOException ioex) {
            this.log.error((Object)("JsonPathUtil>>set:T(TypeReference)>>conversion error:" + ioex));
        }
        return (T)finalJson;
    }

    public DocumentContext set(String jsonString, String path, Object newData) {
        DocumentContext json = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        json.set(path, newData, new Predicate[0]);
        return json;
    }

    public String set(String jsonString, String path, Object newData, boolean returnJsonString) {
        if (returnJsonString) {
            return this.set(jsonString, path, newData).jsonString();
        }
        return null;
    }

    public <T> T search(Object jsonObject, String path) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.search(jsonString, path);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.search(jsonString, path);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>search:T>>caught exception:" + ex));
            return null;
        }
    }

    public String search(Object jsonObject, String path, boolean returnJsonString) {
        Object searched = this.search(jsonObject, path);
        try {
            return this.getObjectMapper().writeValueAsString(searched);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>search:T>>caught exception:" + ex));
            return null;
        }
    }

    public <T> T search(Object jsonObject, String path, TypeRef<T> typeRef) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.search(jsonString, path, typeRef);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.search(jsonString, path, typeRef);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>search:T(typeRef)>>caught exception:" + ex));
            return null;
        }
    }

    public <T> String search(String jsonString, String path, TypeRef<T> typeRef, boolean returnJsonString) {
        T searched = this.search(jsonString, path, typeRef);
        try {
            return this.getObjectMapper().writeValueAsString(searched);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>search:T>>caught exception:" + ex));
            return null;
        }
    }

    public <T> T search(String jsonString, String path) {
        return (T)JsonPath.using((Configuration)this.getAlwaysListConfigWithSuppressedException()).parse(jsonString).read(path, new Predicate[0]);
    }

    public <T> T search(String jsonString, String path, TypeRef<T> typeRef) {
        return (T)JsonPath.using((Configuration)this.getAlwaysListConfigWithSuppressedException()).parse(jsonString).read(path, typeRef);
    }

    public DocumentContext delete(Object jsonObject, String path) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.delete(jsonString, path);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.delete(jsonString, path);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>delete:DocumentContext>>caught exception:" + ex));
            return null;
        }
    }

    public <T> T delete(Object jsonObject, String path, TypeReference<T> typeRef) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.delete(jsonString, path, typeRef);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.delete(jsonString, path, typeRef);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>delete:T(typeRef)>>caught exception:" + ex));
            return null;
        }
    }

    public String delete(Object jsonObject, String path, boolean returnJsonString) {
        if (jsonObject instanceof String) {
            String jsonString = (String)jsonObject;
            return this.delete(jsonString, path, returnJsonString);
        }
        try {
            String jsonString = this.getObjectMapper().writeValueAsString(jsonObject);
            return this.delete(jsonString, path, returnJsonString);
        }
        catch (Exception ex) {
            this.log.error((Object)("JsonPathUtil>>delete:String>>caught exception:" + ex));
            return null;
        }
    }

    public DocumentContext delete(String jsonString, String path) {
        DocumentContext json = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        json.delete(path, new Predicate[0]);
        return json;
    }

    public <T> T delete(String jsonString, String path, TypeReference<T> typeRef) {
        DocumentContext parsedJson = JsonPath.using((Configuration)this.configuration).parse(jsonString);
        parsedJson.delete(path, new Predicate[0]);
        Object finalJson = null;
        try {
            finalJson = this.getObjectMapper().readValue(parsedJson.jsonString(), typeRef);
        }
        catch (IOException ioex) {
            this.log.error((Object)("JsonPathUtil>>delete:T(TypeReference)>>conversion error:" + ioex));
        }
        return (T)finalJson;
    }

    public String delete(String jsonString, String path, boolean returnJsonString) {
        if (returnJsonString) {
            return this.delete(jsonString, path).jsonString();
        }
        return null;
    }

    private Configuration getAlwaysListConfigWithSuppressedException() {
        return Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).mappingProvider((MappingProvider)new JacksonMappingProvider()).options(new Option[]{Option.ALWAYS_RETURN_LIST, Option.SUPPRESS_EXCEPTIONS}).build();
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

