/*
 * Decompiled with CFR 0.152.
 */
package com.github.salilvnair.jsonprocessor.rest.facade;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.salilvnair.jsonprocessor.rest.exception.RestWebServiceException;
import com.github.salilvnair.jsonprocessor.rest.handler.RestWebServiceDelegate;
import com.github.salilvnair.jsonprocessor.rest.handler.RestWebServiceHandler;
import com.github.salilvnair.jsonprocessor.rest.model.RestWebServiceRequest;
import com.github.salilvnair.jsonprocessor.rest.model.RestWebServiceResponse;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestWebServiceFacade {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String REQUEST = "REQUEST";
    public static final String RESPONSE = "RESPONSE";

    public void initiate(RestWebServiceHandler handler, Map<String, Object> restWsMap, Object ... objects) {
        RestWebServiceDelegate delegate;
        if (handler == null) {
            throw new RestWebServiceException("Cannot initiate webservice call without a proper handler class");
        }
        RestWebServiceRequest request = null;
        if (!handler.emptyPayLoad()) {
            request = handler.prepareRequest(restWsMap, objects);
            if (handler.printLogs()) {
                this.printLogs(request, handler, REQUEST);
            }
        }
        if ((delegate = handler.delegate()) == null) {
            throw new RestWebServiceException("Cannot initiate webservice call without a proper client delegate bean for the handler", handler.webServiceName());
        }
        RestWebServiceResponse response = delegate.invoke(request, restWsMap, objects);
        if (handler.printLogs()) {
            this.printLogs(response, handler, RESPONSE);
        }
        handler.processResponse(request, response, restWsMap, objects);
    }

    public void printLogs(Object requestResponse, RestWebServiceHandler handler, String type) {
        String webServiceName = handler.webServiceName();
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = "{}";
        try {
            jsonString = mapper.writeValueAsString(requestResponse);
        }
        catch (Exception ex) {
            this.logger.error((Object)("RestWebServiceFacade>>printLogs>>caught exception:" + ex));
        }
        this.logger.info((Object)("====================================================" + webServiceName + " " + type + " BEGINS================================================="));
        this.logger.info((Object)jsonString);
        this.logger.info((Object)("====================================================" + webServiceName + " " + type + " ENDS================================================="));
    }
}

