/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.Token;

public class MeetupApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "http://www.meetup.com/authenticate?oauth_token=%s";

    private MeetupApi() {
    }

    public static MeetupApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getRequestTokenEndpoint() {
        return "http://api.meetup.com/oauth/request/";
    }

    public String getAccessTokenEndpoint() {
        return "http://api.meetup.com/oauth/access/";
    }

    public String getAuthorizationUrl(Token requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    private static class InstanceHolder {
        private static final MeetupApi INSTANCE = new MeetupApi();

        private InstanceHolder() {
        }
    }
}

