/*
 * Decompiled with CFR 0.152.
 */
package com.github.secondbase.webconsole;

import com.github.secondbase.core.SecondBase;
import com.github.secondbase.core.SecondBaseException;
import com.github.secondbase.core.config.SecondBaseModule;
import com.github.secondbase.webconsole.WebConsoleConfiguration;
import com.github.secondbase.webconsole.widget.Widget;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpWebConsole
implements SecondBaseModule {
    private static final Logger LOG = LoggerFactory.getLogger(HttpWebConsole.class);
    private final HttpServer server = HttpServer.create();
    private final Widget[] widgets;

    public HttpWebConsole() throws IOException {
        this(new Widget[0]);
    }

    public HttpWebConsole(Widget[] widgets) throws IOException {
        this.server.createContext("/healthz", new HealthzHandler());
        this.widgets = widgets;
    }

    public void load(SecondBase secondBase) {
        secondBase.getFlags().loadOpts(WebConsoleConfiguration.class);
    }

    public void init() throws SecondBaseException {
        try {
            this.start();
        }
        catch (IOException e) {
            throw new SecondBaseException("Could not start webconsole.", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    HttpWebConsole.this.shutdown();
                }
                catch (IOException e) {
                    System.err.println("Could not shutdown webconsole: " + e.getMessage());
                }
            }
        });
    }

    public void start() throws IOException {
        if (WebConsoleConfiguration.port == 0) {
            return;
        }
        boolean useSystemDefaultBacklog = false;
        this.server.bind(new InetSocketAddress(WebConsoleConfiguration.port), 0);
        LOG.info("Starting webconsole on port " + WebConsoleConfiguration.port);
        for (Widget widget : this.widgets) {
            LOG.info("Adding webconsole widget " + widget.getPath());
            this.server.createContext(widget.getPath(), widget.getServlet());
        }
        this.server.start();
    }

    public void shutdown() throws IOException {
        if (WebConsoleConfiguration.port == 0) {
            return;
        }
        LOG.info("Shutting down webconsole.");
        this.server.stop(WebConsoleConfiguration.stopTimeout);
    }

    public int getPort() {
        return WebConsoleConfiguration.port;
    }

    public HttpServer getServer() {
        return this.server;
    }

    private final class HealthzHandler
    implements HttpHandler {
        private static final String healthyMsg = "Healthy";

        private HealthzHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            byte[] response = healthyMsg.getBytes();
            t.sendResponseHeaders(200, response.length);
            OutputStream os = t.getResponseBody();
            os.write(response);
            os.close();
        }
    }
}

