/*
 * Decompiled with CFR 0.152.
 */
package vendors.grid;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Allure;
import io.qameta.allure.model.Link;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import vendors.grid.TestInfo;
import vendors.grid.VendorInterface;

public class Element34VendorSBox
implements VendorInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(Element34VendorSBox.class);
    public static final String P_12 = "pki.p12";
    public static final String PW = "pki.pw";

    @Override
    public void addCapibilities(TestInfo info, MutableCapabilities mutableCapabilities) {
        mutableCapabilities.setCapability("e34:l_testName", info.getTestname());
        if (!Strings.isNullOrEmpty((String)TestDataProvider.getTestData(P_12))) {
            File p12 = new File(TestDataProvider.getTestData(P_12));
            try {
                byte[] bytes = Files.readAllBytes(Paths.get(p12.getAbsolutePath(), new String[0]));
                String myP12InBase64 = Base64.getEncoder().encodeToString(bytes);
                HashMap<String, String> pkiAuth = new HashMap<String, String>();
                pkiAuth.put("p12", myP12InBase64);
                pkiAuth.put("password", TestDataProvider.getTestData(PW));
                mutableCapabilities.setCapability("e34:pki_auth", pkiAuth);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException("Fail PKI init", e);
            }
        }
    }

    @Override
    public void onTestSuccess(TestInfo info) {
    }

    @Override
    public void onTestFailure(TestInfo info) {
    }

    @Override
    public void onTestStart(TestInfo info) {
    }

    @Override
    public void onTestSkipped(TestInfo info) {
    }

    @Override
    public void createVideo(TestInfo info, SessionId sessionId) {
        Element34VendorSBox.createVideoLink(sessionId);
    }

    private static void createVideoLink(SessionId id) {
        ImmutableMap map;
        boolean isVideoActive = false;
        if (!Strings.isNullOrEmpty((String)System.getProperty("capabilities")) && (map = ImmutableMap.copyOf((Map)Splitter.on((char)',').withKeyValueSeparator("=").split((CharSequence)System.getProperty("capabilities")))).get("e34:video") != null && ((String)map.get("e34:video")).equals("true")) {
            isVideoActive = true;
        }
        if (id != null && isVideoActive) {
            Element34VendorSBox.saveVideo(id);
        }
    }

    private static void saveVideo(SessionId id) {
        try {
            AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.VideoDownload));
            Thread.sleep(200L);
            Allure.addAttachment((String)"Video", (String)"video/mp4", (InputStream)new URL(System.getProperty("remote.grid.url") + "/videos/" + id + ".mp4").openStream(), (String)"mp4");
            AllureUtils.stopStepPassed();
        }
        catch (Exception e) {
            LOGGER.error("Downloading Video Faild, create Link");
            Allure.addLinks((Link[])new Link[]{new Link().setName(TestDataProvider.getTestData(AllureTextEnum.VideoLinkName)).setUrl(System.getProperty("remote.grid.url") + "/videos/" + id + ".mp4")});
        }
    }
}

