/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.listeners.testng;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Allure;
import io.qameta.allure.Attachment;
import io.qameta.allure.model.Link;
import io.qameta.allure.model.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.SessionId;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.internal.MethodInstance;
import org.testng.util.Strings;
import seleniumConsulting.ch.selenium.framework.annotation.WebTest;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;
import seleniumConsulting.ch.selenium.framework.metadata.MetadataManager;

public class WebTestAnnotationListener
implements IMethodInterceptor,
ITestListener {
    private static String KEY_BROWSER = "browser";
    private static String KEY_VERSION = "version";

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext iTestContext) {
        ArrayList<IMethodInstance> result = new ArrayList<IMethodInstance>();
        for (IMethodInstance m : methods) {
            WebTest webTest = WebTestAnnotationListener.getWebTest(m);
            if (webTest != null) {
                result.addAll(this.generateMultipleBrowserTests(m));
                continue;
            }
            String desc = m.getMethod().getRealClass().toString() + "." + m.getMethod().getMethodName();
            m.getMethod().setDescription(desc);
            result.add(m);
        }
        return result;
    }

    private List<IMethodInstance> generateMultipleBrowserTests(IMethodInstance method) {
        ArrayList<IMethodInstance> result = new ArrayList<IMethodInstance>();
        WebTest webTest = WebTestAnnotationListener.getWebTest(method);
        String[] browserList = webTest.browser();
        if (browserList.length == 0) {
            browserList = TestDataProvider.getTestData(KEY_BROWSER).split(",");
        }
        for (String browser : browserList) {
            MethodInstance methodInstance = new MethodInstance(method.getMethod().clone());
            this.setMetadataOfTest((IMethodInstance)methodInstance, browser);
            result.add((IMethodInstance)methodInstance);
        }
        return result;
    }

    private void setMetadataOfTest(IMethodInstance methodInstance, String browser) {
        WebTest webTest = WebTestAnnotationListener.getWebTest(methodInstance);
        ImmutableMap browserConfig = ImmutableMap.copyOf((Map)Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)browser));
        String desc = methodInstance.getMethod().getRealClass().toString() + "." + methodInstance.getMethod().getMethodName();
        desc = desc + " B=" + (String)browserConfig.get(KEY_BROWSER);
        desc = desc + (browserConfig.get(KEY_VERSION) != null ? " V=" + (String)browserConfig.get(KEY_VERSION) : "");
        methodInstance.getMethod().setDescription(desc);
        MetadataManager.setMetadata(methodInstance.getMethod(), "browser_name", browserConfig.get(KEY_BROWSER));
        if (browserConfig.get(KEY_VERSION) != null) {
            MetadataManager.setMetadata(methodInstance.getMethod(), "browser_version", browserConfig.get(KEY_VERSION));
        } else {
            MetadataManager.setMetadata(methodInstance.getMethod(), "browser_version", (Object)"");
        }
        this.setMetadataOfConfig(methodInstance, webTest.capibilities(), "capabilities");
    }

    private void setMetadataOfConfig(IMethodInstance methodInstance, String[] config, String metadataKey) {
        if (config.length > 0) {
            Map<String, String> configMap = Arrays.stream(config).collect(Collectors.toMap(c -> c.split("=")[0], c -> c.split("=")[1]));
            MetadataManager.setMetadata(methodInstance, metadataKey, configMap);
        }
    }

    public void onTestStart(ITestResult iTestResult) {
        if (WebTestAnnotationListener.isWebTest(iTestResult)) {
            WebDriverManager.createWebDriver(iTestResult.getMethod());
            if (WebDriverManager.getWebdriver() != null) {
                this.createVideoLink();
            }
        }
    }

    public void onTestSuccess(ITestResult iTestResult) {
        if (WebTestAnnotationListener.isWebTest(iTestResult) && WebDriverManager.getWebdriver() != null) {
            WebDriverManager.getWebdriver().quit();
        }
    }

    public void onTestFailure(ITestResult iTestResult) {
        if (WebTestAnnotationListener.isWebTest(iTestResult) && WebDriverManager.getWebdriver() != null) {
            this.takeScreenshot("Fail Screenshot");
            WebDriverManager.getWebdriver().quit();
        }
    }

    @Attachment(value="{message}", type="image/png")
    public byte[] takeScreenshot(String message) {
        TakesScreenshot takesScreenshot = (TakesScreenshot)(WebDriverManager.getWebdriver().getClass().isAnnotationPresent(Augmentable.class) ? new Augmenter().augment(WebDriverManager.getWebdriver()) : WebDriverManager.getWebdriver());
        return (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES);
    }

    public void onTestSkipped(ITestResult iTestResult) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult iTestResult) {
    }

    public void onStart(ITestContext iTestContext) {
    }

    public void onFinish(ITestContext iTestContext) {
    }

    private void createVideoLink() {
        ImmutableMap map;
        boolean isVideoActive = false;
        SessionId id = WebDriverManager.getWebdriverSessionId();
        if (!Strings.isNullOrEmpty((String)System.getProperty("capabilities")) && (map = ImmutableMap.copyOf((Map)Splitter.on((char)',').withKeyValueSeparator("=").split((CharSequence)System.getProperty("capabilities")))).get("e34:video") != null && ((String)map.get("e34:video")).equals("true")) {
            isVideoActive = true;
        }
        if (id != null && isVideoActive) {
            Allure.addLinks((Link[])new Link[]{new Link().setName("Selenium Box Video").setUrl("https://selenium-box.applications.services.axa-tech.intraxa/videos/" + WebDriverManager.getWebdriverSessionId() + ".mp4")});
        }
    }

    public static List<Parameter> addParameterIfWebTest(List<Parameter> parameters, ITestNGMethod method) {
        if (WebTestAnnotationListener.isWebTest(method)) {
            String version;
            String browser = (String)MetadataManager.getMetadata(method, "browser_name");
            if (Strings.isNotNullAndNotEmpty((String)browser)) {
                parameters.add(new Parameter().withName("Browser").withValue(browser));
            }
            if (Strings.isNotNullAndNotEmpty((String)(version = (String)MetadataManager.getMetadata(method, "browser_version")))) {
                parameters.add(new Parameter().withName("Version").withValue(version));
            }
        }
        return parameters;
    }

    private static WebTest getWebTest(IMethodInstance methodInstance) {
        return WebTestAnnotationListener.getWebTest(methodInstance.getMethod());
    }

    private static WebTest getWebTest(ITestResult testResult) {
        return WebTestAnnotationListener.getWebTest(testResult.getMethod());
    }

    private static WebTest getWebTest(ITestNGMethod method) {
        return method.getConstructorOrMethod().getMethod().getAnnotation(WebTest.class);
    }

    public static boolean isWebTest(ITestResult testResult) {
        return WebTestAnnotationListener.getWebTest(testResult) != null;
    }

    public static boolean isWebTest(ITestNGMethod method) {
        return WebTestAnnotationListener.getWebTest(method) != null;
    }

    public static boolean isWebTest(IMethodInstance methodInstance) {
        return WebTestAnnotationListener.getWebTest(methodInstance) != null;
    }
}

