package org.testng.annotations;

import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.util.Strings;

public class TestUtil {
    public static Test getTestAnnotation(IMethodInstance methodInstance){
        return methodInstance.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Test.class);
    }

    public static Test getTestAnnotation(ITestResult testResult){
        return getTestAnnotation(testResult.getMethod());
    }

    public static Test getTestAnnotation(ITestNGMethod method){
        return method.getConstructorOrMethod().getMethod().getAnnotation(Test.class);
    }

    public static boolean isIgnoredTest(ITestResult testResult){
        return testResult.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Ignore.class);
    }

    public static boolean isIgnoredTest(ITestNGMethod method){
        return method.getConstructorOrMethod().getMethod().isAnnotationPresent(Ignore.class);
    }

    public static boolean isIgnoredTest(IMethodInstance methodInstance){
        return methodInstance.getMethod().getConstructorOrMethod().getMethod().isAnnotationPresent(Ignore.class);
    }

    public static boolean isWebTest(ITestResult testResult){
        return getTestAnnotation(testResult.getMethod()).seleniumTest();
    }

    public static boolean isWebTest(ITestNGMethod method){
        return getTestAnnotation(method).seleniumTest();
    }

    public static boolean isWebTest(IMethodInstance methodInstance){
        return getTestAnnotation(methodInstance).seleniumTest();
    }

    public static boolean isDataProvided(IMethodInstance methodInstance){
        return Strings.isNotNullAndNotEmpty(getTestAnnotation(methodInstance).dataProvider());
    }

    public static boolean isDataProvided(ITestNGMethod method){
        return Strings.isNotNullAndNotEmpty(getTestAnnotation(method).dataProvider());
    }

    public static boolean isDataProvided(ITestResult testResult){
        return Strings.isNotNullAndNotEmpty(getTestAnnotation(testResult).dataProvider());
    }
}
