/*
 * Decompiled with CFR 0.152.
 */
package seleniumConsulting.ch.selenium.framework.listeners.testng;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Attachment;
import io.qameta.allure.model.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.remote.Augmentable;
import org.openqa.selenium.remote.Augmenter;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.Test;
import org.testng.annotations.TestUtil;
import org.testng.internal.MethodInstance;
import org.testng.util.Strings;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import seleniumConsulting.ch.selenium.framework.driver.WebDriverManager;
import seleniumConsulting.ch.selenium.framework.metadata.MetadataManager;
import vendors.grid.VendorProvider;

public class WebTestAnnotationListener
implements IMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebTestAnnotationListener.class);
    private static String KEY_BROWSER = "browser";
    private static String KEY_VERSION = "version";

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext iTestContext) {
        ArrayList<IMethodInstance> result = new ArrayList<IMethodInstance>();
        for (IMethodInstance m : methods) {
            if (TestUtil.isWebTest(m)) {
                result.addAll(this.generateMultipleBrowserTests(m));
                continue;
            }
            String desc = m.getMethod().getRealClass().toString() + "." + m.getMethod().getMethodName();
            m.getMethod().setDescription(desc);
            result.add(m);
        }
        return result;
    }

    private List<IMethodInstance> generateMultipleBrowserTests(IMethodInstance method) {
        ArrayList<IMethodInstance> result = new ArrayList<IMethodInstance>();
        Test test = TestUtil.getTestAnnotation(method);
        String[] browserList = test.browser();
        if (browserList.length == 0) {
            browserList = TestDataProvider.getTestData(KEY_BROWSER).split(",");
        }
        for (String browser : browserList) {
            MethodInstance methodInstance = new MethodInstance(method.getMethod().clone());
            this.setMetadataOfTest((IMethodInstance)methodInstance, browser);
            result.add((IMethodInstance)methodInstance);
        }
        return result;
    }

    private void setMetadataOfTest(IMethodInstance methodInstance, String browser) {
        Test test = TestUtil.getTestAnnotation(methodInstance);
        ImmutableMap browserConfig = ImmutableMap.copyOf((Map)Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)browser));
        String desc = methodInstance.getMethod().getRealClass().toString() + "." + methodInstance.getMethod().getMethodName();
        desc = desc + " B=" + (String)browserConfig.get(KEY_BROWSER);
        desc = desc + (browserConfig.get(KEY_VERSION) != null ? " V=" + (String)browserConfig.get(KEY_VERSION) : "");
        methodInstance.getMethod().setDescription(desc);
        MetadataManager.setMetadata(methodInstance.getMethod(), "browser_name", browserConfig.get(KEY_BROWSER));
        if (browserConfig.get(KEY_VERSION) != null) {
            MetadataManager.setMetadata(methodInstance.getMethod(), "browser_version", browserConfig.get(KEY_VERSION));
        } else {
            MetadataManager.setMetadata(methodInstance.getMethod(), "browser_version", (Object)"");
        }
        this.setMetadataOfConfig(methodInstance, test.capibilities(), "capabilities");
    }

    private void setMetadataOfConfig(IMethodInstance methodInstance, String[] config, String metadataKey) {
        if (config.length > 0) {
            Map<String, String> configMap = Arrays.stream(config).collect(Collectors.toMap(c -> c.split("=")[0], c -> c.split("=")[1]));
            MetadataManager.setMetadata(methodInstance, metadataKey, configMap);
        }
    }

    public static void onTestStart(ITestResult iTestResult) {
        if (TestUtil.isWebTest(iTestResult) && iTestResult.getThrowable() == null) {
            WebDriverManager.createWebDriver(iTestResult.getMethod());
            VendorProvider.getVendor().onTestStart(iTestResult);
        }
    }

    public static void onTestSuccess(ITestResult iTestResult) {
        if (TestUtil.isWebTest(iTestResult) && WebDriverManager.getWebdriver() != null) {
            SessionId id = WebDriverManager.getWebdriverSessionId();
            VendorProvider.getVendor().onTestSuccess(iTestResult);
            WebDriverManager.quitWebDriver(iTestResult.getMethod());
            VendorProvider.getVendor().createVideo(iTestResult, id);
        }
    }

    public static void onTestFailure(ITestResult iTestResult) {
        if (TestUtil.isWebTest(iTestResult) && WebDriverManager.getWebdriver() != null) {
            WebTestAnnotationListener.takeScreenshot("Fail Screenshot");
            SessionId id = WebDriverManager.getWebdriverSessionId();
            VendorProvider.getVendor().onTestFailure(iTestResult);
            WebDriverManager.quitWebDriver(iTestResult.getMethod());
            VendorProvider.getVendor().createVideo(iTestResult, id);
        }
    }

    public static void onTestSkipped(ITestResult iTestResult) {
        if (TestUtil.isWebTest(iTestResult) && WebDriverManager.getWebdriver() != null) {
            VendorProvider.getVendor().onTestSkipped(iTestResult);
            WebDriverManager.quitWebDriver(iTestResult.getMethod());
        }
    }

    @Attachment(value="{message}", type="image/png")
    public static byte[] takeScreenshot(String message) {
        TakesScreenshot takesScreenshot = (TakesScreenshot)(WebDriverManager.getWebdriver().getClass().isAnnotationPresent(Augmentable.class) ? new Augmenter().augment(WebDriverManager.getWebdriver()) : WebDriverManager.getWebdriver());
        return (byte[])takesScreenshot.getScreenshotAs(OutputType.BYTES);
    }

    public static List<Parameter> addParameterIfWebTest(List<Parameter> parameters, ITestNGMethod method) {
        if (TestUtil.isWebTest(method)) {
            String version;
            String browser = (String)MetadataManager.getMetadata(method, "browser_name");
            if (Strings.isNotNullAndNotEmpty((String)browser)) {
                parameters.add(new Parameter().withName("Browser").withValue(browser));
            }
            if (Strings.isNotNullAndNotEmpty((String)(version = (String)MetadataManager.getMetadata(method, "browser_version")))) {
                parameters.add(new Parameter().withName("Version").withValue(version));
            }
        }
        return parameters;
    }
}

