/*
 * Decompiled with CFR 0.152.
 */
package vendors.grid;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.qameta.allure.Allure;
import io.qameta.allure.model.Link;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.annotations.TestUtil;
import org.testng.util.Strings;
import seleniumConsulting.ch.selenium.framework.allure.AllureTextEnum;
import seleniumConsulting.ch.selenium.framework.allure.AllureUtils;
import seleniumConsulting.ch.selenium.framework.dataLoader.TestDataProvider;
import vendors.grid.VendorInterface;

public class Element34VendorSBox
implements VendorInterface {
    private static final Logger log = LoggerFactory.getLogger(Element34VendorSBox.class);

    @Override
    public void addCapibilities(ITestNGMethod method, MutableCapabilities mutableCapabilities) {
        String name = TestUtil.getTestAnnotation(method).testName();
        name = Strings.isNotNullAndNotEmpty((String)name) ? name : method.getMethodName();
        mutableCapabilities.setCapability("e34:l_testName", name);
    }

    @Override
    public void onTestSuccess(ITestResult iTestResult) {
    }

    @Override
    public void onTestFailure(ITestResult iTestResult) {
    }

    @Override
    public void onTestStart(ITestResult iTestResult) {
    }

    @Override
    public void onTestSkipped(ITestResult iTestResult) {
    }

    @Override
    public void createVideo(ITestResult iTestResult, SessionId sessionId) {
        Element34VendorSBox.createVideoLink(sessionId);
    }

    private static void createVideoLink(SessionId id) {
        ImmutableMap map;
        boolean isVideoActive = false;
        if (!Strings.isNullOrEmpty((String)System.getProperty("capabilities")) && (map = ImmutableMap.copyOf((Map)Splitter.on((char)',').withKeyValueSeparator("=").split((CharSequence)System.getProperty("capabilities")))).get("e34:video") != null && ((String)map.get("e34:video")).equals("true")) {
            isVideoActive = true;
        }
        if (id != null && isVideoActive) {
            Element34VendorSBox.saveVideo(id);
        }
    }

    private static void saveVideo(SessionId id) {
        try {
            AllureUtils.startStep(TestDataProvider.getTestData(AllureTextEnum.VideoDownload));
            Thread.sleep(200L);
            Allure.addAttachment((String)"Video", (String)"video/mp4", (InputStream)new URL(System.getProperty("remote.grid.url") + "/videos/" + id + ".mp4").openStream(), (String)"mp4");
            AllureUtils.stopStepPassed();
        }
        catch (Exception e) {
            log.error("Downloading Video Faild, create Link");
            Allure.addLinks((Link[])new Link[]{new Link().setName(TestDataProvider.getTestData(AllureTextEnum.VideoLinkName)).setUrl(System.getProperty("remote.grid.url") + "/videos/" + id + ".mp4")});
        }
    }
}

