/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.config;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.sevtech.cloud.storage.spring.config.ConditionalOnCloudStorageProperty;
import com.github.sevtech.cloud.storage.spring.property.AwsS3Properties;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import com.github.sevtech.cloud.storage.spring.service.impl.AwsS3Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnCloudStorageProperty(value="aws.s3.enabled")
public class AwsS3Config {
    private static final Logger log = LoggerFactory.getLogger(AwsS3Config.class);

    @Bean
    public AwsS3Properties awsS3Properties(Environment env) {
        return new AwsS3Properties(env);
    }

    @Bean
    public AmazonS3 awsS3Client(AwsS3Properties awsS3Properties) {
        AmazonS3 client;
        if (awsS3Properties.isLocalstackEnabled().booleanValue()) {
            log.info("Registering AmazonS3Client (with Localstack)");
            client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(awsS3Properties.getLocalstackEndpoint(), awsS3Properties.getLocalstackRegion()))).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
        } else {
            log.info("Registering AmazonS3Client");
            client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(awsS3Properties.getS3AccessKey(), awsS3Properties.getS3SecretKey())))).withRegion(awsS3Properties.getRegion())).build();
        }
        return client;
    }

    @Bean
    public StorageService awsS3Service(AmazonS3 awsS3Client) {
        return new AwsS3Service(awsS3Client);
    }
}

