/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.config;

import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.github.sevtech.cloud.storage.spring.config.ConditionalOnCloudStorageProperty;
import com.github.sevtech.cloud.storage.spring.property.AzureBlobStorageProperties;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import com.github.sevtech.cloud.storage.spring.service.impl.AzureBlobStorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnCloudStorageProperty(value="azure.blob.storage.enabled")
public class AzureBlobStorageConfig {
    private static final Logger log = LoggerFactory.getLogger(AzureBlobStorageConfig.class);

    @Bean
    public AzureBlobStorageProperties azureBlobStorageProperties() {
        return new AzureBlobStorageProperties();
    }

    @Bean
    public BlobServiceClient blobServiceClient(AzureBlobStorageProperties azureBlobStorageProperties) {
        log.info("Registering Azure Blob Storage client");
        return new BlobServiceClientBuilder().connectionString(azureBlobStorageProperties.getConnectionString()).buildClient();
    }

    @Bean
    public StorageService azureBlobStorageService(BlobServiceClient blobServiceClient) {
        return new AzureBlobStorageService(blobServiceClient);
    }
}

