/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.service.azure;

import com.amazonaws.util.IOUtils;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.specialized.BlockBlobClient;
import com.github.sevtech.cloud.storage.spring.exception.NoBucketException;
import com.github.sevtech.cloud.storage.spring.model.BaseResponse;
import com.github.sevtech.cloud.storage.spring.model.DeleteFileRequest;
import com.github.sevtech.cloud.storage.spring.model.DeleteFileResponse;
import com.github.sevtech.cloud.storage.spring.model.GetFileRequest;
import com.github.sevtech.cloud.storage.spring.model.GetFileResponse;
import com.github.sevtech.cloud.storage.spring.model.UploadFileRequest;
import com.github.sevtech.cloud.storage.spring.model.UploadFileResponse;
import com.github.sevtech.cloud.storage.spring.service.AbstractStorageService;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public class AzureBlobStorageService
extends AbstractStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(AzureBlobStorageService.class);
    @Value(value="${azure.blob.storage.container.name}")
    private String defaultContainerName;
    private final BlobServiceClient blobServiceClient;

    @Override
    public UploadFileResponse uploadFile(UploadFileRequest request) {
        try {
            log.info("Uploading file to {}", (Object)this.getFilePath(request));
            InputStream streamToUpload = this.clone(request.getStream());
            BlockBlobClient blockBlobClient = this.getBlobClient(request.getBucketName(), this.getFilePath(request));
            BlobHttpHeaders headers = new BlobHttpHeaders();
            headers.setContentType(request.getContentType());
            blockBlobClient.upload(streamToUpload, (long)IOUtils.toByteArray((InputStream)request.getStream()).length);
            blockBlobClient.setHttpHeaders(headers);
            return ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(200)).comment(blockBlobClient.getBlobUrl())).build();
        }
        catch (NoBucketException | IOException e) {
            log.warn("Error creating blob");
            return ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(500)).cause("Error creating blob")).exception(e)).build();
        }
    }

    @Override
    @Async
    public Future<UploadFileResponse> uploadFileAsync(UploadFileRequest request) {
        return new AsyncResult((Object)this.uploadFile(request));
    }

    @Override
    public GetFileResponse getFile(GetFileRequest request) {
        BaseResponse baseResponse;
        log.info("Reading file from {}", (Object)request.getPath());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            BlockBlobClient blockBlobClient = this.getBlobClient(request.getBucketName(), request.getPath());
            blockBlobClient.downloadStream((OutputStream)outputStream);
            baseResponse = ((GetFileResponse.GetFileResponseBuilder)((BaseResponse.BaseResponseBuilder)GetFileResponse.builder().content(outputStream.toByteArray())).status(200)).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (NoBucketException | IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                return ((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)GetFileResponse.builder().cause(e.getMessage())).exception(e)).status(500)).build();
            }
        }
        outputStream.close();
        return baseResponse;
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest request) {
        log.info("Deleting file from path {}", (Object)request.getPath());
        try {
            BlockBlobClient blockBlobClient = this.getBlobClient(request.getBucketName(), request.getPath());
            blockBlobClient.delete();
            return ((DeleteFileResponse.DeleteFileResponseBuilder)DeleteFileResponse.builder().status(200)).build();
        }
        catch (NoBucketException e) {
            log.error(e.getMessage(), (Throwable)e);
            return ((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)DeleteFileResponse.builder().cause(e.getMessage())).exception(e)).status(500)).build();
        }
    }

    private BlockBlobClient getBlobClient(String bucketName, String path) throws NoBucketException {
        return this.blobServiceClient.getBlobContainerClient(this.getBucketName(bucketName, this.defaultContainerName)).getBlobClient(path).getBlockBlobClient();
    }

    public AzureBlobStorageService(BlobServiceClient blobServiceClient) {
        this.blobServiceClient = blobServiceClient;
    }
}

