/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.service.dropbox;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxClientV2;
import com.github.sevtech.cloud.storage.spring.model.BaseResponse;
import com.github.sevtech.cloud.storage.spring.model.DeleteFileRequest;
import com.github.sevtech.cloud.storage.spring.model.DeleteFileResponse;
import com.github.sevtech.cloud.storage.spring.model.GetFileRequest;
import com.github.sevtech.cloud.storage.spring.model.GetFileResponse;
import com.github.sevtech.cloud.storage.spring.model.UploadFileRequest;
import com.github.sevtech.cloud.storage.spring.model.UploadFileResponse;
import com.github.sevtech.cloud.storage.spring.service.AbstractStorageService;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import java.io.IOException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public class DropboxService
extends AbstractStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(DropboxService.class);
    private final DbxClientV2 dbxClientV2;

    @Override
    public UploadFileResponse uploadFile(UploadFileRequest request) {
        try {
            log.info("Uploading file to {}", (Object)this.getFilePath(request));
            this.dbxClientV2.files().uploadBuilder("/" + this.getFilePath(request)).uploadAndFinish(request.getStream());
            return ((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(200)).build();
        }
        catch (DbxException | IOException e) {
            return ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(500)).cause(e.getLocalizedMessage())).exception((Exception)e)).build();
        }
    }

    @Override
    @Async
    public Future<UploadFileResponse> uploadFileAsync(UploadFileRequest request) {
        return new AsyncResult((Object)this.uploadFile(request));
    }

    @Override
    public GetFileResponse getFile(GetFileRequest request) {
        try {
            log.info("Reading file from {}", (Object)request.getPath());
            DbxDownloader download = this.dbxClientV2.files().download(request.getPath());
            return ((GetFileResponse.GetFileResponseBuilder)((BaseResponse.BaseResponseBuilder)GetFileResponse.builder().content(new byte[download.getInputStream().available()])).status(200)).build();
        }
        catch (DbxException | IOException e) {
            return ((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)GetFileResponse.builder().status(500)).cause(e.getLocalizedMessage())).exception((Exception)e)).build();
        }
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest request) {
        try {
            log.info("Deleting file from path {}", (Object)request.getPath());
            this.dbxClientV2.files().deleteV2(request.getPath());
            return ((DeleteFileResponse.DeleteFileResponseBuilder)((BaseResponse.BaseResponseBuilder)DeleteFileResponse.builder().result(true)).status(200)).build();
        }
        catch (DbxException e) {
            return ((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)DeleteFileResponse.builder().status(500)).cause(e.getLocalizedMessage())).exception((Exception)((Object)e))).build();
        }
    }

    public DropboxService(DbxClientV2 dbxClientV2) {
        this.dbxClientV2 = dbxClientV2;
    }
}

