/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevtech.cloud.storage.spring.service.gcloud;

import com.amazonaws.util.IOUtils;
import com.github.sevtech.cloud.storage.spring.exception.NoBucketException;
import com.github.sevtech.cloud.storage.spring.model.BaseResponse;
import com.github.sevtech.cloud.storage.spring.model.DeleteFileRequest;
import com.github.sevtech.cloud.storage.spring.model.DeleteFileResponse;
import com.github.sevtech.cloud.storage.spring.model.GetFileRequest;
import com.github.sevtech.cloud.storage.spring.model.GetFileResponse;
import com.github.sevtech.cloud.storage.spring.model.UploadFileRequest;
import com.github.sevtech.cloud.storage.spring.model.UploadFileResponse;
import com.github.sevtech.cloud.storage.spring.service.AbstractStorageService;
import com.github.sevtech.cloud.storage.spring.service.StorageService;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;

public class GoogleCloudStorageService
extends AbstractStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(GoogleCloudStorageService.class);
    @Value(value="${gcp.storage.bucket.name}")
    private String defaultBucketName;
    private final Storage storageClient;

    @Override
    public UploadFileResponse uploadFile(UploadFileRequest request) {
        try {
            log.info("Uploading file to {}", (Object)this.getFilePath(request));
            String bucketName = this.getBucketName(request.getBucketName(), this.defaultBucketName);
            Blob blobInfo = this.storageClient.create(BlobInfo.newBuilder((String)bucketName, (String)this.getFilePath(request)).build(), IOUtils.toByteArray((InputStream)request.getStream()), new Storage.BlobTargetOption[0]);
            return ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(200)).comment(blobInfo.getMediaLink())).build();
        }
        catch (NoBucketException | IOException e) {
            log.warn("Error creating blob");
            return ((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((UploadFileResponse.UploadFileResponseBuilder)((BaseResponse.BaseResponseBuilder)UploadFileResponse.builder().fileName(request.getName())).status(500)).cause("Error creating blob")).exception(e)).build();
        }
    }

    @Override
    @Async
    public Future<UploadFileResponse> uploadFileAsync(UploadFileRequest uploadFileRequest) {
        return new AsyncResult((Object)this.uploadFile(uploadFileRequest));
    }

    @Override
    public GetFileResponse getFile(GetFileRequest request) {
        log.info("Reading file from {}", (Object)request.getPath());
        try {
            byte[] file = this.storageClient.readAllBytes(BlobId.of((String)this.getBucketName(request.getBucketName(), this.defaultBucketName), (String)request.getPath()), new Storage.BlobSourceOption[0]);
            return ((GetFileResponse.GetFileResponseBuilder)((BaseResponse.BaseResponseBuilder)GetFileResponse.builder().content(file)).status(200)).build();
        }
        catch (NoBucketException e) {
            log.error(e.getMessage(), (Throwable)e);
            return ((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)((GetFileResponse.GetFileResponseBuilder)GetFileResponse.builder().cause(e.getMessage())).exception(e)).status(500)).build();
        }
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest request) {
        log.info("Deleting file from path {}", (Object)request.getPath());
        try {
            this.storageClient.delete(BlobId.of((String)this.getBucketName(request.getBucketName(), this.defaultBucketName), (String)request.getPath()));
            return ((DeleteFileResponse.DeleteFileResponseBuilder)((BaseResponse.BaseResponseBuilder)DeleteFileResponse.builder().result(true)).status(200)).build();
        }
        catch (NoBucketException e) {
            log.error(e.getMessage(), (Throwable)e);
            return ((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)((DeleteFileResponse.DeleteFileResponseBuilder)DeleteFileResponse.builder().cause(e.getMessage())).exception(e)).status(500)).build();
        }
    }

    public GoogleCloudStorageService(Storage storageClient) {
        this.storageClient = storageClient;
    }
}

