/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.queryloader.impl;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.sparta.springwebutils.queryloader.QueryLoader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class FileQueryLoader
implements QueryLoader,
InitializingBean {
    private static final ConcurrentMap<String, String> QUERY_CACHE = new ConcurrentHashMap<String, String>(50);
    private String scriptsFolder;

    public FileQueryLoader(String scriptsFolder) {
        this.scriptsFolder = StringUtils.appendIfMissing((String)scriptsFolder, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    @Override
    public String load(String queryName) {
        if (!QUERY_CACHE.containsKey(queryName)) {
            QUERY_CACHE.put(queryName, this.loadfromFromFile(queryName));
        }
        return (String)QUERY_CACHE.get(queryName);
    }

    @Override
    public String[] loadMultiple(String queryName, char separator) {
        String fullSql = this.load(queryName);
        return StringUtils.split((String)fullSql, (char)separator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadfromFromFile(String queryName) throws IllegalStateException {
        try (InputStream is = this.getClass().getResourceAsStream(this.scriptsFolder + queryName + ".sql");){
            String sql = StringUtils.join((Iterable)IOUtils.readLines((InputStream)is), (char)' ');
            String[] tokens = StringUtils.substringsBetween((String)sql, (String)"${", (String)"}");
            if (tokens != null && tokens.length > 0) {
                Map values = Arrays.stream(tokens).collect(Collectors.toMap(Function.identity(), this::load, (o, n) -> o));
                sql = StrSubstitutor.replace((Object)sql, values);
            }
            String string = sql;
            return string;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not load query " + this.scriptsFolder + queryName, e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.scriptsFolder, (String)"scriptsFolder cannot be null");
    }
}

