/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ManifestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManifestUtils.class);
    private static final String MANIFEST = "META-INF/MANIFEST.MF";
    @Autowired
    private ServletContext servletContext;

    public String getManifestAttribute(String attributeName) {
        if (attributeName != null) {
            Map<Object, Object> mf = this.getManifestAttributes();
            for (Object att : mf.keySet()) {
                if (!attributeName.equals(att.toString())) continue;
                return mf.get(att).toString();
            }
        }
        return null;
    }

    public Map<Object, Object> getManifestAttributes() {
        Map<Object, Object> manifestAttributes = null;
        manifestAttributes = this.getExplodedWarManifestAttributes();
        if (manifestAttributes == null) {
            manifestAttributes = this.getPackagedWarManifestAttributes();
        }
        if (manifestAttributes == null) {
            manifestAttributes = this.getClassPathManifestAttributes();
        }
        if (manifestAttributes == null) {
            manifestAttributes = new HashMap<Object, Object>();
        }
        return manifestAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, Object> getExplodedWarManifestAttributes() {
        Attributes manifestAttributes = null;
        FileInputStream fis = null;
        try {
            if (this.servletContext != null) {
                String appServerHome = this.servletContext.getRealPath("");
                File manifestFile = new File(appServerHome, MANIFEST);
                fis = new FileInputStream(manifestFile);
                Manifest mf = new Manifest(fis);
                manifestAttributes = mf.getMainAttributes();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to read the manifest file from the servlet context.");
            LOGGER.debug("Unable to read the manifest file", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(fis);
        }
        return manifestAttributes;
    }

    private Map<Object, Object> getClassPathManifestAttributes() {
        Attributes manifestAttributes = null;
        try {
            Manifest manifest = new Manifest(this.getClass().getClassLoader().getResourceAsStream(MANIFEST));
            manifestAttributes = manifest.getMainAttributes();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read the manifest from the classpath");
            LOGGER.debug("Unable to read the manifest from the classpath", (Throwable)e);
        }
        return manifestAttributes;
    }

    private Map<Object, Object> getPackagedWarManifestAttributes() {
        Attributes manifestAttributes = null;
        try {
            Manifest manifest = new Manifest(this.servletContext.getResourceAsStream(MANIFEST));
            manifestAttributes = manifest.getMainAttributes();
        }
        catch (IOException e) {
            LOGGER.warn("Unable to read the manifest from the packaged war");
            LOGGER.debug("Unable to read the manifest from the packaged", (Throwable)e);
        }
        return manifestAttributes;
    }
}

