/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils.lambda;

import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.sparta.springwebutils.lambda.CheckedExceptionWrapper;
import org.sparta.springwebutils.lambda.Processable;
import org.springframework.dao.DataAccessException;

public abstract class ExceptionUtility {
    public static Set<SQLException> getAllSqlExceptionsForBatchExecution(DataAccessException dae) {
        LinkedHashSet<SQLException> result = new LinkedHashSet<SQLException>();
        if (dae.getMostSpecificCause() instanceof BatchUpdateException) {
            BatchUpdateException ex = (BatchUpdateException)dae.getMostSpecificCause();
            for (SQLException se = ex.getNextException(); se != null; se = se.getNextException()) {
                result.add(se);
            }
        }
        return result;
    }

    public static void trapException(Processable processable, Consumer<Exception> exceptionConsumer) {
        try {
            processable.process();
        }
        catch (Exception e) {
            exceptionConsumer.accept(e);
        }
    }

    public static void trapAndLogException(Processable processable, String errorMessage, Logger logger) {
        ExceptionUtility.trapException(processable, ex -> logger.error(errorMessage, (Throwable)ex));
    }

    public static void trapAndWrapInCheckedException(Processable processable) throws CheckedExceptionWrapper {
        ExceptionUtility.trapException(processable, e -> {
            throw new CheckedExceptionWrapper((Exception)e);
        });
    }
}

