/*
 * Decompiled with CFR 0.152.
 */
package org.sparta.springwebutils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparta.springwebutils.entity.EntryPoint;
import org.sparta.springwebutils.entity.EntryPointParameter;
import org.sparta.springwebutils.util.ExternalEntryPointHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.http.HttpRequest;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);
    @Autowired
    private RequestMappingHandlerMapping handlerMapping;
    private List<String> paramNamesBlacklist = new ArrayList<String>();
    private List<Class<?>> paramTypesBlacklist = new ArrayList();
    private boolean scanEntryPointAnnotation;
    private ParameterNameDiscoverer nameDiscover;
    private Integer maxDeepLevel;

    public RequestUtils() {
        this.paramTypesBlacklist.add(BindingResult.class);
        this.paramTypesBlacklist.add(HttpServletRequest.class);
        this.paramTypesBlacklist.add(HttpRequest.class);
        this.paramTypesBlacklist.add(HttpServletResponse.class);
        this.paramTypesBlacklist.add(HttpSession.class);
        this.paramTypesBlacklist.add(Map.class);
        this.paramTypesBlacklist.add(Model.class);
        this.paramTypesBlacklist.add(Class.class);
        this.scanEntryPointAnnotation = true;
        this.nameDiscover = new LocalVariableTableParameterNameDiscoverer();
        this.maxDeepLevel = 3;
    }

    public List<EntryPoint> retrieveAllExternalEntryPoints() {
        ArrayList<EntryPoint> entryPoints = new ArrayList<EntryPoint>();
        Map allUrls = this.handlerMapping.getHandlerMethods();
        for (RequestMappingInfo mappingInfo : allUrls.keySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)allUrls.get(mappingInfo);
            if (mappingInfo.getPatternsCondition() == null || !ExternalEntryPointHelper.isAnEntryPoint(handlerMethod.getMethod(), this.scanEntryPointAnnotation)) continue;
            EntryPoint entryPoint = new EntryPoint();
            entryPoint.setParameters(new ArrayList<EntryPointParameter>());
            entryPoint.setUrls(mappingInfo.getPatternsCondition().getPatterns());
            if (mappingInfo.getMethodsCondition() != null) {
                entryPoint.setRequestMethods(mappingInfo.getMethodsCondition().getMethods());
            }
            Method method = handlerMethod.getMethod();
            entryPoint.setMethodName(method.getName());
            entryPoint.setMethodDecorationName(ExternalEntryPointHelper.getEntryPointDecoratedName(method, this.scanEntryPointAnnotation));
            entryPoint.setType(method.getDeclaringClass());
            entryPoint.setResponseType(method.getReturnType());
            String[] parameterNames = this.nameDiscover.getParameterNames(method);
            Set<Class<?>> consolidatedTypeBlacklist = ExternalEntryPointHelper.getConsolidatedTypeBlacklist(this.paramTypesBlacklist, method, this.scanEntryPointAnnotation);
            Set<String> consolidatedNameBlacklist = ExternalEntryPointHelper.getConsolidatedNameBlacklist(this.paramNamesBlacklist, method, this.scanEntryPointAnnotation);
            for (MethodParameter methodParameter : handlerMethod.getMethodParameters()) {
                this.computeInputParatemeter(entryPoint, parameterNames, consolidatedTypeBlacklist, consolidatedNameBlacklist, methodParameter);
            }
            entryPoints.add(entryPoint);
        }
        return entryPoints;
    }

    private void computeInputParatemeter(EntryPoint entryPoint, String[] parameterNames, Set<Class<?>> consolidatedTypeBlacklist, Set<String> consolidatedNameBlacklist, MethodParameter methodParameter) {
        if (consolidatedTypeBlacklist.contains(methodParameter.getParameterType())) {
            LOGGER.debug("Ignoring parameter type [{}]. It is on the blacklist.", (Object)methodParameter.getParameterType());
            return;
        }
        if (ExternalEntryPointHelper.isSimpleRequestParameter(methodParameter.getParameterType())) {
            String parameterRealName = parameterNames[methodParameter.getParameterIndex()];
            LOGGER.debug("Parameter Real Name [{}]", (Object)parameterRealName);
            if (consolidatedNameBlacklist.contains(parameterRealName)) {
                LOGGER.debug("Ignoring parameter name [{}]. It is on the blacklist.", (Object)parameterRealName);
                return;
            }
            EntryPointParameter entryPointParameter = new EntryPointParameter();
            entryPointParameter.setName(parameterRealName);
            entryPointParameter.setType(methodParameter.getParameterType());
            if (methodParameter.hasParameterAnnotation(RequestParam.class)) {
                RequestParam requestParam = (RequestParam)methodParameter.getParameterAnnotation(RequestParam.class);
                String definedName = StringUtils.trimToEmpty((String)requestParam.value());
                if (consolidatedNameBlacklist.contains(definedName)) {
                    LOGGER.debug("Ignoring parameter @RequestParam defined name [{}]. It is on the blacklist.", (Object)definedName);
                    return;
                }
                entryPointParameter.setName(StringUtils.isNotBlank((CharSequence)definedName) ? definedName : entryPointParameter.getName());
                entryPointParameter.setRequired(requestParam.required());
                entryPointParameter.setDefaultValue(StringUtils.equals((CharSequence)"\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n", (CharSequence)requestParam.defaultValue()) ? "" : requestParam.defaultValue());
            }
            entryPoint.getParameters().add(entryPointParameter);
        } else if (!methodParameter.getParameterType().isArray()) {
            entryPoint.getParameters().addAll(ExternalEntryPointHelper.getInternalEntryPointParametersRecursively(methodParameter.getParameterType(), consolidatedTypeBlacklist, consolidatedNameBlacklist, this.maxDeepLevel));
        }
    }

    public void setParamNamesBlacklist(List<String> paramNamesBlacklist) {
        this.paramNamesBlacklist = paramNamesBlacklist;
    }

    public void setParamTypesBlacklist(List<Class<?>> paramTypesBlacklist) {
        this.paramTypesBlacklist = paramTypesBlacklist;
    }

    public void setExtraParamTypesBlacklist(List<Class<?>> extraParamTypesBlacklist) {
        this.paramTypesBlacklist.addAll(extraParamTypesBlacklist);
    }

    public void setScanEntryPointAnnotation(boolean scanEntryPointAnnotation) {
        this.scanEntryPointAnnotation = scanEntryPointAnnotation;
    }

    public void setNameDiscover(ParameterNameDiscoverer nameDiscover) {
        this.nameDiscover = nameDiscover;
    }

    public void setMaxDeepLevel(Integer maxDeepLevel) {
        this.maxDeepLevel = maxDeepLevel;
    }
}

