package com.github.springbootPlus;

/*
 * Copyright 2001-2005 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.myframework.util.FileUtil;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

//import org.myframework.util.CHZipUtils;

/**
 * Goal which show project param
 *
 * @goal init
 */
public class InitToolMojo extends AbstractMojo {
    /**
     * Location of the file.
     *
     * @parameter expression="${project.build.directory}"
     * @required
     */
    private File outputDirectory;

    /**
     * Maven内置变量说明：
     * ${basedir} 项目根目录
     * ${project.build.directory} 构建目录，缺省为target
     * ${project.build.outputDirectory} 构建过程输出目录，缺省为target/classes
     * ${project.build.finalName} 产出物名称，缺省为${project.artifactId}-${project.version}
     * ${project.packaging} 打包类型，缺省为jar
     * ${project.xxx} 当前pom文件的任意节点的内容
     * Location of the file.
     *
     * @parameter expression="${basedir}"
     * @required
     */
    private File baseDirectory;
    /**
     * Location of the file.
     *
     * @parameter expression="${java.home}"
     * @required
     */
    private String javaHome;

    public void execute()
            throws MojoExecutionException {
        System.out.println(outputDirectory);
        System.out.println(baseDirectory);
        System.out.println(getPluginContext());
        System.out.println("javaHome" + javaHome);
        String basedir =   baseDirectory+"/coderhelp/" ;
        FileUtil.createDir(basedir);
        try {
            String configfile = "coderhelp.zip";
            Files.copy(FileUtil.getInputStream(configfile), Paths.get(basedir + configfile));
            System.out.println("please unzip  " + basedir+ configfile);
//            CHZipUtils.unZip(basedir+ configfile, basedir);
        } catch (IOException e) {
            //
            e.printStackTrace();
        }
    }
}
