/*
 * Decompiled with CFR 0.152.
 */
package ste.web.http;

import java.util.NoSuchElementException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import ste.web.http.HttpSession;

public class ConfigurationSessionFactory {
    public static final long DEFAULT_LIFETIME = 900000L;
    public static final String REGEX_VALID_NAME = "[_a-zA-Z][_a-zA-Z0-9]*";
    private final long lifetime;
    private final String sessionIdName;

    public ConfigurationSessionFactory(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration can not be null");
        }
        try {
            configuration.getLong("ste.https.session.lifetime");
        }
        catch (ConversionException x) {
            throw new ConfigurationException("ste.https.session.lifetime must be a number (seconds)");
        }
        catch (NoSuchElementException x) {
            // empty catch block
        }
        String sessionIdName = configuration.getString("ste.https.session.name");
        if (sessionIdName != null && !sessionIdName.matches(REGEX_VALID_NAME)) {
            throw new ConfigurationException("ste.https.session.name '" + sessionIdName + "' must be a valid identifier (" + REGEX_VALID_NAME + ")");
        }
        long sessionLifetime = configuration.getLong("ste.https.session.lifetime", 900000L);
        this.sessionIdName = sessionIdName == null ? "HTTPSID" : sessionIdName;
        this.lifetime = sessionLifetime > 0L ? sessionLifetime : 0L;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public String getSessionIdName() {
        return this.sessionIdName;
    }

    public HttpSession create() {
        return new HttpSession(this.sessionIdName);
    }
}

