/*
 * Decompiled with CFR 0.152.
 */
package ste.web.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.protocol.UriHttpRequestHandlerMapper;
import ste.web.http.BasicHttpConnection;
import ste.web.http.BasicHttpConnectionFactory;
import ste.web.http.ConfigurationSessionFactory;
import ste.web.http.HttpSessionService;
import ste.web.http.handlers.RestrictedResourceHandler;

public class HttpServer {
    public static final String LOG_ACCESS = "ste.https.access";
    public static final String LOG_SERVER = "ste.https.server";
    public static final String CERT_ALIAS = "ste.https";
    final Logger LOG = Logger.getLogger("ste.https.server");
    private SSLServerSocketFactory sf;
    private int sslPort;
    private int webPort;
    private HttpSessionService ssl;
    private HttpSessionService web;
    private boolean running;
    private RequestListenerThread listenerThread;
    private RequestListenerThread webListenerThread;
    private ClientAuthentication authentication;
    private Configuration configuration;
    UriHttpRequestHandlerMapper sslMapper;
    UriHttpRequestHandlerMapper webMapper;

    public HttpServer(Configuration configuration) throws ConfigurationException {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration can not be null");
        }
        this.configure(configuration);
    }

    public HttpServer(String configurationFilename) throws ConfigurationException {
        if (StringUtils.isBlank((CharSequence)configurationFilename)) {
            throw new IllegalArgumentException("configuration can not be empty");
        }
        File configurationFile = new File(configurationFilename);
        if (!configurationFile.exists()) {
            throw new ConfigurationException("configuration file " + configurationFile.getAbsolutePath() + " not found");
        }
        this.configure((Configuration)new PropertiesConfiguration(configurationFilename));
    }

    public void start() {
        block7: {
            ServerSocket webSocket;
            block6: {
                SSLServerSocket sslSocket = null;
                webSocket = null;
                this.running = true;
                if (this.sslPort > 0) {
                    try {
                        sslSocket = (SSLServerSocket)this.sf.createServerSocket(this.sslPort);
                        sslSocket.setNeedClientAuth(this.authentication == ClientAuthentication.CERTIFICATE);
                        this.listenerThread = new RequestListenerThread(this, sslSocket);
                        this.listenerThread.setDaemon(true);
                        this.listenerThread.start();
                    }
                    catch (IOException x) {
                        if (!this.LOG.isLoggable(Level.INFO)) break block6;
                        this.LOG.info(String.format("unable to start the server because it was not possible to bind port %d (%s)", this.sslPort, x.getMessage().toLowerCase()));
                    }
                }
            }
            if (this.webPort > 0) {
                try {
                    webSocket = new ServerSocket(this.webPort);
                    this.webListenerThread = new RequestListenerThread(this, webSocket);
                    this.webListenerThread.setDaemon(true);
                    this.webListenerThread.start();
                }
                catch (IOException x) {
                    if (!this.LOG.isLoggable(Level.INFO)) break block7;
                    this.LOG.info(String.format("unable to start the server because it was not possible to bind port %d (%s)", this.webPort, x.getMessage().toLowerCase()));
                }
            }
        }
    }

    public void stop() {
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
            try {
                this.listenerThread.join(1000L);
            }
            catch (InterruptedException x) {
                throw new RuntimeException(x);
            }
        }
        if (this.webListenerThread != null) {
            this.webListenerThread.interrupt();
            try {
                this.webListenerThread.join(1000L);
            }
            catch (InterruptedException x) {
                throw new RuntimeException(x);
            }
        }
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public HttpSessionService getSSLService() {
        return this.ssl;
    }

    public HttpSessionService getWebService() {
        return this.web;
    }

    public int getSSLPort() {
        return this.sslPort;
    }

    public int getWebPort() {
        return this.webPort;
    }

    public ClientAuthentication getAuthentication() {
        return this.authentication;
    }

    public void setHandlers(HashMap<String, HttpRequestHandler> handlers, HttpProcessor processor) {
        ConfigurationSessionFactory sessionFactory = null;
        try {
            sessionFactory = new ConfigurationSessionFactory(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        if (processor == null) {
            processor = this.buildDefaultHttpProcessor();
        }
        if (handlers != null) {
            this.sslMapper = new UriHttpRequestHandlerMapper();
            this.webMapper = new UriHttpRequestHandlerMapper();
            for (String pattern : handlers.keySet()) {
                HttpRequestHandler handler = handlers.get(pattern);
                this.sslMapper.register(pattern, handler);
                if (handler instanceof RestrictedResourceHandler) continue;
                this.webMapper.register(pattern, handler);
            }
            this.ssl = this.sslPort > 0 ? new HttpSessionService(processor, (HttpRequestHandlerMapper)this.sslMapper, sessionFactory) : null;
            this.web = this.webPort > 0 ? new HttpSessionService(processor, (HttpRequestHandlerMapper)this.webMapper, sessionFactory) : null;
        } else {
            UriHttpRequestHandlerMapper registry = new UriHttpRequestHandlerMapper();
            this.ssl = this.sslPort > 0 ? new HttpSessionService(processor, (HttpRequestHandlerMapper)registry, sessionFactory) : null;
            this.web = this.webPort > 0 ? new HttpSessionService(processor, (HttpRequestHandlerMapper)registry, sessionFactory) : null;
        }
    }

    public void setHandlers(HashMap<String, HttpRequestHandler> handlers) {
        this.setHandlers(handlers, null);
    }

    public HttpRequestHandlerMapper getWebHandlers() {
        return this.webMapper;
    }

    public HttpRequestHandlerMapper getSSLHandlers() {
        return this.sslMapper;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void configure(Configuration c) throws ConfigurationException {
        this.configuration = c;
        String home = this.configuration.getString("ste.https.root");
        if (StringUtils.isBlank((CharSequence)home)) {
            throw new ConfigurationException("the server home directory is unset or blank; please specify a proper value for the property ste.https.root");
        }
        File fileHome = new File(home);
        if (!fileHome.exists() || !fileHome.isDirectory()) {
            throw new ConfigurationException(String.format("the given home [%s] must exist and must be a directory", home));
        }
        this.sslPort = this.configPort("ssl");
        this.webPort = this.configPort("web");
        try {
            String password = this.configuration.getString("ste.https.ssl.password");
            this.sf = this.getSSLContext(home, password).getServerSocketFactory();
        }
        catch (Exception x) {
            throw new ConfigurationException(x.getMessage(), (Throwable)x);
        }
        String auth = this.configuration.getString("ste.https.auth");
        this.authentication = ClientAuthentication.BASIC;
        if ("none".equalsIgnoreCase(auth)) {
            this.authentication = ClientAuthentication.NONE;
        } else if ("cert".equalsIgnoreCase(auth)) {
            this.authentication = ClientAuthentication.CERTIFICATE;
        }
        new ConfigurationSessionFactory(this.configuration);
        this.running = false;
        this.listenerThread = null;
        this.webListenerThread = null;
        this.setHandlers(null);
    }

    private SSLContext getSSLContext(String home, String password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new UnrecoverableKeyException("ssl password not provided; set the system propoerty ste.https.ssl.password");
        }
        char[] sslPassword = password.toCharArray();
        String keystoreFile = home + "/conf/keystore";
        KeyStore keystore = KeyStore.getInstance("jks");
        keystore.load(new FileInputStream(keystoreFile), sslPassword);
        Certificate serverCertificate = keystore.getCertificate(CERT_ALIAS);
        if (serverCertificate == null) {
            throw new CertificateException(String.format("missing server certificate with alias '%s' in keystore %s", CERT_ALIAS, keystoreFile));
        }
        KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmfactory.init(keystore, sslPassword);
        X509KeyManager x509KeyManager = (X509KeyManager)kmfactory.getKeyManagers()[0];
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(new KeyManager[]{new HttpKeyManager(x509KeyManager)}, null, null);
        return context;
    }

    private HttpProcessor buildDefaultHttpProcessor() {
        return HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer()).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).build();
    }

    private int configPort(String whichPort) throws ConfigurationException {
        String KEY = "web".equals(whichPort) ? "ste.https.web.port" : "ste.https.ssl.port";
        int DEFAULT = "web".equals(whichPort) ? 8400 : 8484;
        int p = 0;
        try {
            p = this.configuration.getInt(KEY, DEFAULT);
        }
        catch (ConversionException x) {
            throw new ConfigurationException("the " + whichPort + " port <" + this.configuration.getProperty(KEY) + "> is invalid; please specify a proper value for the property " + KEY);
        }
        return p;
    }

    private class HttpKeyManager
    implements X509KeyManager {
        private X509KeyManager defaultKeyManager;

        public HttpKeyManager(X509KeyManager defaultKeyManager) {
            this.defaultKeyManager = defaultKeyManager;
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.defaultKeyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            return this.defaultKeyManager.chooseClientAlias(keyType, issuers, socket);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.defaultKeyManager.getServerAliases(keyType, issuers);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return HttpServer.CERT_ALIAS;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.defaultKeyManager.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.defaultKeyManager.getPrivateKey(alias);
        }
    }

    static class WorkerThread
    extends Thread {
        private final HttpSessionService http;
        private final HttpServerConnection conn;

        public WorkerThread(HttpSessionService http, HttpServerConnection conn) {
            this.http = http;
            this.conn = conn;
        }

        @Override
        public void run() {
            Logger LOG = Logger.getLogger(HttpServer.LOG_SERVER);
            try {
                if (!Thread.interrupted() && this.conn.isOpen()) {
                    this.http.handleRequest(this.conn);
                }
            }
            catch (ConnectionClosedException x) {
                LOG.fine(String.format("connection closed by the client (%s)", x.getMessage()));
            }
            catch (IOException x) {
                LOG.fine(String.format("io error (%s)", x.getMessage()));
            }
            catch (HttpException x) {
                LOG.fine(String.format("http error (%s)", x.getMessage()));
            }
            finally {
                try {
                    this.conn.shutdown();
                }
                catch (IOException x) {}
            }
        }
    }

    static class RequestListenerThread
    extends Thread {
        private final ServerSocket serverSocket;
        private final HttpServer server;
        private final boolean isSSL;

        public RequestListenerThread(HttpServer server, ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
            this.server = server;
            this.isSSL = this.serverSocket.getLocalPort() == server.sslPort;
        }

        @Override
        public void run() {
            Logger LOG = Logger.getLogger(HttpServer.LOG_SERVER);
            while (this.server.isRunning() && !Thread.interrupted()) {
                Socket socket = null;
                BasicHttpConnection conn = null;
                try {
                    if (LOG.isLoggable(Level.INFO)) {
                        LOG.info(String.format("starting %s listener on port %d", this.isSSL ? "ssl" : "web", this.serverSocket.getLocalPort()));
                    }
                    socket = this.serverSocket.accept();
                }
                catch (IOException x) {
                    if (!LOG.isLoggable(Level.INFO)) break;
                    LOG.info(String.format("stopping to listen on port %d (%s)", this.serverSocket.getLocalPort(), x.getMessage()));
                    break;
                }
                try {
                    conn = BasicHttpConnectionFactory.INSTANCE.createConnection(socket);
                }
                catch (IOException x) {
                    if (!LOG.isLoggable(Level.INFO)) break;
                    LOG.info(String.format("stopping to create connections on port %d (%s)", this.serverSocket.getLocalPort(), x.getMessage()));
                    break;
                }
                WorkerThread t = new WorkerThread(this.isSSL ? this.server.getSSLService() : this.server.getWebService(), (HttpServerConnection)conn);
                t.setDaemon(true);
                t.start();
            }
        }

        @Override
        public void interrupt() {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            }
        }
    }

    public static enum ClientAuthentication {
        BASIC,
        NONE,
        CERTIFICATE;

    }
}

