/*
 * Decompiled with CFR 0.152.
 */
package ste.web.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.Principal;
import java.util.logging.Logger;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpServerConnection;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandlerMapper;
import org.apache.http.protocol.HttpService;
import ste.web.acl.User;
import ste.web.http.ConfigurationSessionFactory;
import ste.web.http.HttpSession;
import ste.web.http.HttpSessionContext;
import ste.web.http.HttpUtils;
import ste.web.http.SessionCache;

public class HttpSessionService
extends HttpService {
    public static final String LOG_PATTERN = "%s - %s \"%s\" %d";
    private Logger LOG = Logger.getLogger("ste.https.access");
    private SessionCache sessions;

    public HttpSessionService(HttpProcessor processor, HttpRequestHandlerMapper handlerMapper, ConfigurationSessionFactory sessionFactory) {
        super(processor, handlerMapper);
        this.sessions = new SessionCache(sessionFactory);
    }

    public void handleRequest(HttpServerConnection c) throws HttpException, IOException {
        super.handleRequest(c, (HttpContext)new HttpSessionContext());
    }

    protected void doService(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String sessionId = this.sessionId(request, (HttpSessionContext)context);
        HttpSession session = this.sessions.get(sessionId);
        ((HttpSessionContext)context).setSession(session);
        if (!session.getId().equals(sessionId)) {
            response.setHeader((Header)session.getHeader());
        }
        response.setEntity((HttpEntity)this.createEmptyEntity());
        HttpInetConnection connection = (HttpInetConnection)context.getAttribute("http.connection");
        InetAddress remoteAddress = connection.getRemoteAddress();
        this.setPrincipal(request, (HttpSessionContext)context);
        super.doService(request, response, context);
        this.LOG.info(String.format(LOG_PATTERN, remoteAddress.toString().substring(1), session.getId(), request.getRequestLine().toString(), response.getStatusLine().getStatusCode()));
    }

    private String sessionId(HttpRequest request, HttpSessionContext context) {
        for (Header h : request.getHeaders("Cookie")) {
            String sessionId = HttpUtils.extractSessionId((String)this.sessions.getSessionIdName(), (String)h.getValue());
            if (sessionId == null) continue;
            return sessionId;
        }
        return null;
    }

    private void setPrincipal(HttpRequest request, HttpSessionContext context) {
        Header h = request.getFirstHeader("Authorization");
        if (h != null) {
            context.setPrincipal((Principal)this.userFromAuthotizationHeader(h));
        }
    }

    private BasicHttpEntity createEmptyEntity() {
        BasicHttpEntity e = new BasicHttpEntity();
        e.setContentLength(0L);
        e.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        return e;
    }

    private User userFromAuthotizationHeader(Header authorization) {
        Pair cred = HttpUtils.parseBasicAuth((Header)authorization);
        User user = null;
        if (cred != null) {
            user = new User((String)cred.getLeft());
            user.setSecret((String)cred.getRight());
        }
        return user;
    }
}

