/*
 * Decompiled with CFR 0.152.
 */
package ste.web.http;

import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import ste.web.http.ConfigurationSessionFactory;
import ste.web.http.HttpSession;

class SessionCache
extends HashMap<String, HttpSession> {
    private Clock clock = Clock.systemDefaultZone();
    public static final long DEFAULT_SESSION_LIFETIME = 900000L;
    public static final long DEFAULT_SESSION_PURGETIME = 5000L;
    private final Map<String, Long> lastAccess;
    private final ConfigurationSessionFactory sessionFactory;
    private final long lifetime;
    private final long purgetime;
    private long lastPurge;
    private String sessionIdName;

    public SessionCache(ConfigurationSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.lifetime = sessionFactory.getLifetime();
        this.sessionIdName = sessionFactory.getSessionIdName();
        this.purgetime = 5000L;
        this.lastPurge = 0L;
        this.lastAccess = new HashMap<String, Long>();
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public String getSessionIdName() {
        return this.sessionIdName;
    }

    @Override
    public HttpSession put(String id, HttpSession session) {
        throw new UnsupportedOperationException("put() is unsupported; use get(null) instead");
    }

    @Override
    public void putAll(Map<? extends String, ? extends HttpSession> map) {
        throw new UnsupportedOperationException("putAll() is unsupported; use get(null) instead");
    }

    public synchronized HttpSession get(String id) {
        HttpSession session = (HttpSession)super.get(id);
        this.purge();
        Long lastTS = this.lastAccess.get(id);
        if (lastTS == null || this.isExpired(lastTS) || session == null) {
            session = this.sessionFactory.create();
            super.put(session.getId(), session);
        }
        this.trackAccess(session.getId());
        return session;
    }

    protected boolean isExpired(Long lastTS) {
        long ts = this.clock.millis();
        return this.lifetime != 0L && ts - lastTS > this.lifetime;
    }

    private void expireSession(String id) {
        if (this.lifetime != 0L && id != null) {
            HttpSession session = (HttpSession)super.get(id);
            if (session != null) {
                session.expire();
            }
            this.remove(id);
            this.lastAccess.remove(id);
        }
    }

    private void trackAccess(String id) {
        this.lastAccess.put(id, this.clock.millis());
    }

    private void purge() {
        Object[] access;
        if (this.lifetime == 0L) {
            return;
        }
        long ts = this.clock.millis();
        if (ts - this.lastPurge <= this.purgetime) {
            return;
        }
        for (Object o : access = this.lastAccess.entrySet().toArray()) {
            Map.Entry a = (Map.Entry)o;
            long lastTS = (Long)a.getValue();
            if (!this.isExpired(lastTS)) continue;
            this.expireSession((String)a.getKey());
        }
        this.lastPurge = ts;
    }
}

