/*
 * Decompiled with CFR 0.152.
 */
package ste.web.security;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class CertificateBuilder {
    private final String SIGNING_ALGHORITM = "SHA512withRSA";
    private final String dn;
    private final long validFrom;
    private final long validTo;
    private KeyPair keys;

    public CertificateBuilder(String dn) {
        if (StringUtils.isBlank((String)dn)) {
            throw new IllegalArgumentException("dn can not be blank");
        }
        this.dn = dn;
        Calendar calendar = Calendar.getInstance();
        this.validFrom = calendar.getTimeInMillis();
        calendar.add(1, 2);
        this.validTo = calendar.getTimeInMillis();
    }

    public String getDN() {
        return this.dn;
    }

    public Date getValidFrom() {
        return new Date(this.validFrom);
    }

    public Date getValidTo() {
        return new Date(this.validTo);
    }

    public KeyPair getKeyPair() {
        return this.keys;
    }

    public CertificateBuilder generateKeyPair() {
        try {
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
            keyGenerator.initialize(1024, SecureRandom.getInstance("SHA1PRNG", "SUN"));
            this.keys = keyGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException generalSecurityException) {
            // empty catch block
        }
        return this;
    }

    public X509Certificate build() {
        if (this.keys == null) {
            this.generateKeyPair();
        }
        PrivateKey privkey = this.keys.getPrivate();
        X509CertInfo info = new X509CertInfo();
        CertificateValidity interval = new CertificateValidity(new Date(this.validFrom), new Date(this.validTo));
        BigInteger sn = new BigInteger(64, new SecureRandom());
        try {
            X500Name owner = new X500Name(this.dn);
            info.set("validity", interval);
            info.set("serialNumber", new CertificateSerialNumber(sn));
            info.set("subject", owner);
            info.set("issuer", owner);
            info.set("key", new CertificateX509Key(this.keys.getPublic()));
            info.set("version", new CertificateVersion(2));
            AlgorithmId algo = new AlgorithmId(AlgorithmId.md5WithRSAEncryption_oid);
            info.set("algorithmID", new CertificateAlgorithmId(algo));
            X509CertImpl cert = new X509CertImpl(info);
            cert.sign(privkey, "SHA512withRSA");
            algo = (AlgorithmId)cert.get("x509.algorithm");
            info.set("algorithmID.algorithm", algo);
            cert = new X509CertImpl(info);
            cert.sign(privkey, "SHA512withRSA");
            return cert;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }
}

